/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import htsjdk.tribble.Feature;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.igv.exceptions.ParserException;
import org.igv.feature.BasicFeature;
import org.igv.feature.FeatureFileUtils;
import org.igv.feature.FeatureParser;
import org.igv.feature.genome.Genome;
import org.igv.feature.gff.GFFCombiner;
import org.igv.feature.gff.GFFFeatureSource;
import org.igv.feature.tribble.GFFCodec;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.TrackLoader;
import org.igv.track.TrackProperties;

@Deprecated
public class GFFParser
implements FeatureParser {
    static Logger log = LogManager.getLogger(GFFParser.class);
    private TrackProperties trackProperties = null;
    public static Set<String> geneParts = new HashSet<String>();

    @Override
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome) {
        return this.loadFeatures(reader, genome, new GFFCodec(genome, null));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<Feature> loadFeatures(BufferedReader reader, Genome genome, GFFCodec codec) {
        String line = null;
        int lineNumber = 0;
        GFFCombiner combiner = GFFFeatureSource.getCombiner(codec.getVersion());
        try {
            while ((line = reader.readLine()) != null) {
                ++lineNumber;
                if (line.startsWith("#")) {
                    codec.readHeaderLine(line);
                    continue;
                }
                try {
                    BasicFeature f = codec.decode(line);
                    if (f == null) continue;
                    combiner.addFeature(f);
                }
                catch (Exception e) {
                    log.error("Error parsing: " + line, e);
                }
            }
        }
        catch (IOException ex) {
            log.error("Error reading GFF file", ex);
            if (line != null && lineNumber != 0) {
                throw new ParserException(ex.getMessage(), (Throwable)ex, lineNumber, line);
            }
            throw new RuntimeException(ex);
        }
        this.trackProperties = TrackLoader.getTrackProperties(codec.getHeader());
        List<Feature> iFeatures = combiner.combineFeatures();
        if (genome != null) {
            genome.getFeatureDB().addFeatures(iFeatures);
        }
        return iFeatures;
    }

    @Override
    public TrackProperties getTrackProperties() {
        return this.trackProperties;
    }

    public static void main(String[] args) throws IOException {
        if (args.length < 2) {
            System.out.println("SpitFilesByType <gffFile> <outputDirectory>");
            return;
        }
        FeatureFileUtils.splitGffFileByType(args[0], args[1]);
    }

    static {
        geneParts.add("five_prime_UTR");
        geneParts.add("three_prime_UTR");
        geneParts.add("5'-utr");
        geneParts.add("3'-utr");
        geneParts.add("3'-UTR");
        geneParts.add("5'-UTR");
        geneParts.add("5utr");
        geneParts.add("3utr");
        geneParts.add("CDS");
        geneParts.add("cds");
        geneParts.add("exon");
        geneParts.add("coding_exon");
        geneParts.add("intron");
        geneParts.add("transcript");
        geneParts.add("processed_transcript");
        geneParts.add("mrna");
        geneParts.add("mRNA");
    }
}

