/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import java.util.ArrayList;
import java.util.List;
import org.igv.feature.BasicFeature;
import org.igv.feature.Exon;
import org.igv.feature.FormatUtils;
import org.igv.feature.Strand;
import org.igv.track.WindowFunction;

public class GFFFeature
extends BasicFeature {
    List<String> componentAttributes = new ArrayList<String>();

    public GFFFeature(BasicFeature feature) {
        super(feature);
    }

    public GFFFeature(String chr, int start, int end, Strand strand) {
        super(chr, start, end, strand);
    }

    @Override
    public void addExon(Exon region) {
        super.addExon(region);
    }

    @Override
    public void addUTRorCDS(BasicFeature bf) {
        super.addUTRorCDS(bf);
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction ignored) {
        StringBuffer valueString = new StringBuffer();
        valueString.append("<b>type:</b>&nbsp;" + this.type);
        if (this.attributes != null) {
            valueString.append(this.getAttributeString());
        }
        if (this.componentAttributes.size() > 0) {
            for (String s : this.componentAttributes) {
                valueString.append("---------------------------");
                valueString.append(s);
            }
        }
        return valueString.toString();
    }

    public void mergeAttributes(BasicFeature mrnaPart) {
        StringBuffer buf = new StringBuffer();
        buf.append("<br><b>type:</b>&nbsp;" + mrnaPart.getType());
        FormatUtils.printAttributes(mrnaPart.getAttributes(), buf, 100);
        this.componentAttributes.add(buf.toString());
    }
}

