/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import java.util.Map;

public class FormatUtils {
    private static final int MAX_CHARS_PER_LINE = 200;

    public static void printAttributes(Map<String, String> map, StringBuffer buffer, int max) {
        if (map == null || map.isEmpty()) {
            return;
        }
        int count = 0;
        buffer.append("<br>");
        for (Map.Entry<String, String> entry : map.entrySet()) {
            if (entry.getKey().startsWith("_")) continue;
            String value = entry.getValue();
            buffer.append("<b>" + entry.getKey() + "</b>");
            buffer.append(":&nbsp;");
            Object ts = value.startsWith("https://") ? "<a href='" + value + "'>" + value + "</a>" : FormatUtils.lineWrapString(value, 200);
            buffer.append((String)ts);
            buffer.append("<br/>");
            ++count;
            if (++count <= max) continue;
            buffer.append("...");
            break;
        }
    }

    private static String lineWrapString(String input, int maxCharsPerLine) {
        int lines = input.length() / maxCharsPerLine + 1;
        if (lines == 1) {
            return input;
        }
        Object result = input.substring(0, maxCharsPerLine);
        for (int lineNum = 1; lineNum < lines; ++lineNum) {
            int start = lineNum * maxCharsPerLine;
            int end = Math.min(start + maxCharsPerLine, input.length());
            result = (String)result + "<br/>" + input.substring(start, end);
        }
        return result;
    }
}

