/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import com.jidesoft.utils.SortedList;
import htsjdk.tribble.Feature;
import htsjdk.tribble.NamedFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.igv.feature.BasicFeature;
import org.igv.feature.Exon;
import org.igv.feature.IGVFeature;
import org.igv.feature.IGVNamedFeature;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.Track;
import org.igv.ui.IGV;

public class FeatureDB {
    private static Logger log = LogManager.getLogger(FeatureDB.class);
    private Map<String, List<NamedFeature>> featureMap = Collections.synchronizedSortedMap(new TreeMap());
    private final int MAX_DUPLICATE_COUNT = 20;

    public void addFeature(NamedFeature feature) {
        String name = feature.getName();
        if (name != null && name.length() > 0 && !name.equals(".")) {
            this.put(name, feature);
        }
        if (feature instanceof BasicFeature) {
            BasicFeature igvFeature = (BasicFeature)feature;
            String id = igvFeature.getIdentifier();
            if (id != null && id.length() > 0) {
                this.put(id, feature);
            }
            this.addByAttributes(igvFeature);
            List<Exon> exons = igvFeature.getExons();
            if (exons != null) {
                for (Exon exon : exons) {
                    this.addByAttributes(exon);
                }
            }
        }
    }

    private void addByAttributes(IGVFeature igvFeature) {
        List<String> attributeKeys = igvFeature.getAttributeKeys();
        for (String key : attributeKeys) {
            String value = igvFeature.getAttribute(key);
            if (value.length() >= 50) continue;
            this.put(value, igvFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void put(String name, NamedFeature feature) {
        List currentList;
        String key = name.toUpperCase();
        List list = currentList = this.featureMap.computeIfAbsent(key, k -> new SortedList(new ArrayList(), (Comparator)FeatureComparator.get(true)));
        synchronized (list) {
            if (currentList.size() < 20) {
                currentList.add(feature);
            }
        }
    }

    public void addFeature(String name, IGVNamedFeature feature) {
        this.put(name.toUpperCase(), feature);
    }

    public void addFeatures(List<Feature> features) {
        for (Feature feature : features) {
            if (!(feature instanceof IGVFeature)) continue;
            this.addFeature((IGVFeature)feature);
        }
    }

    public void clearFeatures() {
        this.featureMap.clear();
    }

    int size() {
        return this.featureMap.size();
    }

    public NamedFeature getFeature(String name) {
        String nm = name.trim().toUpperCase();
        List<NamedFeature> features = this.featureMap.get(nm);
        if (features != null) {
            return features.get(0);
        }
        return null;
    }

    public List<NamedFeature> getFeaturesMatching(String name) {
        String nm = name.trim().toUpperCase();
        List<NamedFeature> features = this.featureMap.get(nm);
        if (features == null || features.isEmpty()) {
            features = new ArrayList<NamedFeature>();
            List<Track> searchableTracks = IGV.getInstance().getAllTracks().stream().filter(Track::isSearchable).toList();
            for (Track t : searchableTracks) {
                List<NamedFeature> matches = t.search(name);
                if (matches == null || matches.size() <= 0) continue;
                features.addAll(matches);
                for (NamedFeature match : matches) {
                    this.put(nm, match);
                }
            }
        }
        return features != null ? features : Collections.emptyList();
    }

    Map<String, List<NamedFeature>> getFeaturesMap(String name) {
        String nm = name.trim().toUpperCase();
        SortedMap treeMap = (SortedMap)this.featureMap;
        return treeMap.subMap(nm, nm + "\uffff");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<NamedFeature> getFeaturesStartingWith(String name, int limit) {
        Map<String, List<NamedFeature>> map = this.featureMap;
        synchronized (map) {
            Map<String, List<NamedFeature>> resultMap = this.getFeaturesMap(name);
            Set<String> names = resultMap.keySet();
            Iterator<String> nameIter = names.iterator();
            ArrayList<NamedFeature> features = new ArrayList<NamedFeature>(Math.min(limit, names.size()));
            for (int ii = 0; nameIter.hasNext() && ii < limit; ++ii) {
                List<NamedFeature> subFeats = resultMap.get(nameIter.next());
                features.add(subFeats.get(0));
            }
            return features;
        }
    }

    private static class FeatureComparator
    implements Comparator<Feature> {
        private boolean descending;
        private static FeatureComparator ascending_instance;
        private static FeatureComparator descending_instance;

        public static FeatureComparator get(boolean descending) {
            FeatureComparator instance;
            if (descending) {
                if (ascending_instance == null) {
                    ascending_instance = new FeatureComparator(descending);
                }
                instance = ascending_instance;
            } else {
                if (descending_instance == null) {
                    descending_instance = new FeatureComparator(descending);
                }
                instance = descending_instance;
            }
            return instance;
        }

        private FeatureComparator(boolean reverse) {
            this.descending = reverse;
        }

        @Override
        public int compare(Feature feat1, Feature feat2) {
            int nameLen2;
            int nameLen1 = feat1.getChr().length();
            if (nameLen1 != (nameLen2 = feat2.getChr().length())) {
                return nameLen1 - nameLen2;
            }
            int len1 = feat1.getEnd() - feat1.getStart();
            int len2 = feat2.getEnd() - feat2.getStart();
            int toRet = !this.descending ? len1 - len2 : len2 - len1;
            return toRet;
        }
    }
}

