/*
 * Decompiled with CFR 0.152.
 */
package org.igv.data.cufflinks;

import org.igv.data.cufflinks.CufflinksValue;
import org.igv.feature.LocusScore;
import org.igv.track.WindowFunction;

public class ExpDiffValue
extends CufflinksValue
implements LocusScore {
    float log2Ratio;
    float fpkmX;
    float fpkmY;
    String significant;

    public ExpDiffValue(String chr, int start, int end, String gene, float log2Ratio, float fpkmX, float fpkmY, String significant) {
        super(chr, start, end, gene);
        this.log2Ratio = log2Ratio;
        this.fpkmX = fpkmX;
        this.fpkmY = fpkmY;
        this.significant = significant;
    }

    @Override
    public float getScore() {
        return this.log2Ratio;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChr() + ":" + (this.getStart() + 1) + "-" + this.getEnd());
        sb.append("<br>gene = " + this.gene);
        sb.append("<br>log2(y/x) = " + this.log2Ratio);
        sb.append("<br>FPKM X = " + this.fpkmX);
        sb.append("<br>FPKM Y = " + this.fpkmY);
        sb.append("<br>Significant? " + this.significant);
        return sb.toString();
    }
}

