/*
 * Decompiled with CFR 0.152.
 */
package org.igv.data.cufflinks;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.StatUtils;
import org.igv.data.BasicScore;
import org.igv.data.DataSource;
import org.igv.data.GenomeSummaryData;
import org.igv.data.cufflinks.FPKMSampleValue;
import org.igv.data.cufflinks.FPKMValue;
import org.igv.feature.FeatureUtils;
import org.igv.feature.LocusScore;
import org.igv.feature.genome.Genome;
import org.igv.track.TrackType;
import org.igv.track.WindowFunction;
import org.igv.util.collections.DownsampledDoubleArrayList;

public class CufflinksDataSource
implements DataSource {
    double dataMax;
    double dataMin;
    Map<String, List<LocusScore>> values;
    Map<String, String> chrAliasMap = new HashMap<String, String>();
    List<LocusScore> wholeGenomeScores;
    private int sampleIndex = 0;

    public CufflinksDataSource(int sampleIndex, List<FPKMValue> allValues, Genome genome) {
        this(CufflinksDataSource.getSampleValues(sampleIndex, allValues), genome);
        this.sampleIndex = sampleIndex;
    }

    private static List<? extends LocusScore> getSampleValues(int sampleIndex, List<FPKMValue> allValues) {
        ArrayList<FPKMSampleValue> sampleValueList = new ArrayList<FPKMSampleValue>(allValues.size());
        for (FPKMValue value : allValues) {
            sampleValueList.add(value.getSampleValue(sampleIndex));
        }
        return sampleValueList;
    }

    public CufflinksDataSource(List<? extends LocusScore> valueList, Genome genome) {
        this.values = new HashMap<String, List<LocusScore>>();
        DownsampledDoubleArrayList sampledData = this.sampleValues(valueList, genome);
        for (List<LocusScore> chrValues : this.values.values()) {
            FeatureUtils.sortFeatureList(chrValues);
        }
        double[] sd = sampledData.toArray();
        if (sd.length > 0) {
            this.dataMin = Math.min(0.0, StatUtils.percentile((double[])sd, (double)5.0));
            this.dataMax = StatUtils.percentile((double[])sd, (double)95.0);
        } else {
            this.dataMin = 0.0;
            this.dataMax = 100.0;
        }
        this.calculateWholeGenomeScores(genome);
    }

    private void calculateWholeGenomeScores(Genome genome) {
        GenomeSummaryData genomeSummaryData = new GenomeSummaryData(genome, new String[]{"*"});
        for (Map.Entry<String, List<LocusScore>> entry : this.values.entrySet()) {
            String chr = entry.getKey();
            List<LocusScore> scores = entry.getValue();
            int[] positions = new int[scores.size()];
            float[] values = new float[scores.size()];
            for (int i = 0; i < scores.size(); ++i) {
                LocusScore s = scores.get(i);
                positions[i] = s.getStart();
                values[i] = s.getScore();
            }
            HashMap<String, float[]> tmp = new HashMap<String, float[]>(1);
            tmp.put("*", values);
            genomeSummaryData.addData(chr, positions, tmp);
        }
        int[] positions = genomeSummaryData.getLocations();
        float[] values = genomeSummaryData.getData("*");
        this.wholeGenomeScores = new ArrayList<LocusScore>(positions.length);
        for (int i = 0; i < positions.length; ++i) {
            this.wholeGenomeScores.add(new BasicScore(positions[i], positions[i] + 1, values[i]));
        }
    }

    private DownsampledDoubleArrayList sampleValues(List<? extends LocusScore> valueList, Genome genome) {
        DownsampledDoubleArrayList sampledData = new DownsampledDoubleArrayList(5000, 10000);
        for (LocusScore locusScore : valueList) {
            String chr = locusScore.getChr();
            List<LocusScore> chrValues = this.values.get(chr);
            if (chrValues == null) {
                chrValues = new ArrayList<LocusScore>();
                this.values.put(chr, chrValues);
                if (genome != null) {
                    String alias = genome.getCanonicalChrName(chr);
                    this.chrAliasMap.put(alias, chr);
                }
            }
            sampledData.add(locusScore.getScore());
            chrValues.add(locusScore);
        }
        return sampledData;
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    public List<LocusScore> getSummaryScoresForRange(String chr, int startLocation, int endLocation, int zoom) {
        if (chr.equals("All")) {
            return this.wholeGenomeScores;
        }
        if (this.chrAliasMap.containsKey(chr)) {
            return this.values.get(this.chrAliasMap.get(chr));
        }
        return this.values.get(chr);
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.FPKM;
    }

    @Override
    public void setWindowFunction(WindowFunction statType) {
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return Arrays.asList(WindowFunction.none);
    }

    @Override
    public void dispose() {
    }
}

