/*
 * Decompiled with CFR 0.152.
 */
package org.igv.data;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.igv.util.FileUtils;

public class ZipUtils {
    public static void zipDirectory(File dir2Zip, File outputFile) {
        try {
            ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(outputFile));
            ZipUtils.zipDirRecursive(dir2Zip, dir2Zip, zos);
            zos.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void zipDirRecursive(File zipDir, File currentDir, ZipOutputStream zos) {
        try {
            String[] dirList = zipDir.list();
            byte[] readBuffer = new byte[2156];
            int bytesIn = 0;
            for (File f : currentDir.listFiles()) {
                if (f.isDirectory()) {
                    ZipUtils.zipDirRecursive(zipDir, f, zos);
                    continue;
                }
                FileInputStream fis = new FileInputStream(f);
                String relativePath = FileUtils.getRelativePath(zipDir.getAbsolutePath(), f.getAbsolutePath(), System.getProperty("file.separator"));
                String piPath = FileUtils.getPlatformIndependentPath(relativePath);
                if (piPath.startsWith("./")) {
                    piPath = piPath.substring(2);
                }
                ZipEntry anEntry = new ZipEntry(piPath);
                anEntry.setMethod(0);
                anEntry.setCompressedSize(f.length());
                anEntry.setSize(f.length());
                anEntry.setCrc(ZipUtils.getCrc(f));
                zos.putNextEntry(anEntry);
                while ((bytesIn = fis.read(readBuffer)) != -1) {
                    zos.write(readBuffer, 0, bytesIn);
                }
                fis.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static long getCrc(File file) throws IOException {
        CRC32 crc = new CRC32();
        crc.reset();
        byte[] buffer = new byte[1024];
        int bytesRead = 0;
        BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
        while ((bytesRead = bis.read(buffer)) != -1) {
            crc.update(buffer, 0, bytesRead);
        }
        bis.close();
        return crc.getValue();
    }
}

