/*
 * Decompiled with CFR 0.152.
 */
package org.igv.charts;

import java.awt.geom.Path2D;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.igv.charts.ScatterPlotData;
import org.igv.charts.XYDataPoint;
import org.igv.charts.XYSeries;

public class XYDataModel {
    private Map<String, XYSeries> seriesMap = new HashMap<String, XYSeries>();
    private String categoryName;
    private String xLabel;
    private String yLabel;
    ScatterPlotData scatterPlotData;

    public XYDataModel(String categoryName, String xLabel, String yLabel, ScatterPlotData scatterPlotData) {
        this.categoryName = categoryName;
        this.xLabel = xLabel;
        this.yLabel = yLabel;
        this.scatterPlotData = scatterPlotData;
    }

    public void addSeries(XYSeries xySeries) {
        int idx = this.seriesMap.size();
        this.seriesMap.put(xySeries.getName(), xySeries);
    }

    public int numPoints(String seriesName) {
        XYSeries series = this.seriesMap.get(seriesName);
        return series == null ? 0 : series.getSize();
    }

    public List<XYDataPoint> getDataPoints(String seriesName) {
        XYSeries series = this.seriesMap.get(seriesName);
        return series == null ? null : series.getDataPoints();
    }

    public Collection<String> getSeriesNames() {
        return this.seriesMap.keySet();
    }

    public String getCategoryName() {
        return this.categoryName;
    }

    public String getXLabel() {
        return this.xLabel;
    }

    public String getYLabel() {
        return this.yLabel;
    }

    public XYDataPoint getDataPointAtPixel(double x, double y, double toleranceX, double toleranceY) {
        for (XYSeries series : this.seriesMap.values()) {
            XYDataPoint dp = series.getDataPoint(x, y, toleranceX, toleranceY);
            if (dp == null) continue;
            return dp;
        }
        return null;
    }

    public Set<XYDataPoint> getDataPointsIn(Path2D path) {
        HashSet<XYDataPoint> points = new HashSet<XYDataPoint>();
        for (XYSeries series : this.seriesMap.values()) {
            List<XYDataPoint> dataPoints = series.getDataPoints();
            for (XYDataPoint dataPoint : dataPoints) {
                if (!path.contains(dataPoint.getX(), dataPoint.getY())) continue;
                points.add(dataPoint);
            }
        }
        return points;
    }
}

