/*
 * Decompiled with CFR 0.152.
 */
package org.igv.charts;

import java.util.LinkedHashMap;
import org.igv.charts.ScatterPlotData;
import org.igv.charts.ScatterPlotFrame;
import org.igv.track.TrackType;
import org.igv.ui.util.UIUtilities;

public class ScatterPlotDemo {
    private static int igvSampleCount;
    private static ScatterPlotData igvData;
    private static ScatterPlotFrame igvPlotFrame;

    public ScatterPlotDemo(int sampleCount) {
        igvData = this.getTestData(sampleCount);
        igvPlotFrame = new ScatterPlotFrame(igvData);
        UIUtilities.invokeOnEventThread(new Runnable(this){

            @Override
            public void run() {
                igvPlotFrame.setVisible(true);
            }
        });
    }

    public ScatterPlotData getTestData(int sampleCount) {
        String[] samples = new String[sampleCount];
        double[] cnData = new double[sampleCount];
        double[] exprData = new double[sampleCount];
        double[] methData = new double[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            samples[i] = "Sample " + i;
            double x = (double)(i - sampleCount / 2) * 3.1415 / (double)sampleCount;
            double y = 5.0 * Math.sin(i);
            cnData[i] = x;
            exprData[i] = y;
            methData[i] = y;
        }
        LinkedHashMap<String, double[]> dataMap = new LinkedHashMap<String, double[]>();
        dataMap.put(TrackType.COPY_NUMBER.toString(), cnData);
        dataMap.put(TrackType.GENE_EXPRESSION.toString(), exprData);
        dataMap.put(TrackType.DNA_METHYLATION.toString(), methData);
        String[] treated = new String[sampleCount];
        String[] hyperMutated = new String[sampleCount];
        String[] cluster = new String[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            double classValue;
            String string = treated[i] = Math.random() > 0.5 ? "AA" : "B";
            if (i % 6 == 0) {
                treated[i] = "null";
            }
            String string2 = hyperMutated[i] = Math.random() > 0.9 ? "Y" : "N";
            if (i % 7 == 0) {
                hyperMutated[i] = "null";
            }
            cluster[i] = (classValue = Math.random()) > 0.9 ? "Proneural" : (classValue > 0.8 ? "neural" : (classValue > 0.6 ? "classical" : (classValue > 0.4 ? "mesenchymal" : "unknown")));
        }
        LinkedHashMap<String, String[]> symbolMap = new LinkedHashMap<String, String[]>();
        symbolMap.put("Treatment", treated);
        symbolMap.put("Hyper mutated", hyperMutated);
        symbolMap.put("Cluster Type", cluster);
        int[] mutationCount = new int[sampleCount];
        for (int i = 0; i < sampleCount; ++i) {
            mutationCount[i] = (int)(2.0 * Math.random());
        }
        return new ScatterPlotData("Test", samples, symbolMap, dataMap, mutationCount);
    }

    public static void main(String[] args) {
        int demoPoints = 500;
        ScatterPlotDemo demo = new ScatterPlotDemo(demoPoints);
    }
}

