/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.awt.Color;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.BedPEShape;
import org.igv.feature.genome.Genome;

class WGFeature
implements BedPE {
    private final int start1;
    private final int end1;
    private final int start2;
    private final int end2;
    private final BedPE feature;

    WGFeature(BedPE f, Genome genome) {
        this.feature = f;
        this.start1 = genome.getGenomeCoordinate(f.getChr1(), f.getStart1());
        this.end1 = genome.getGenomeCoordinate(f.getChr1(), f.getEnd1());
        this.start2 = genome.getGenomeCoordinate(f.getChr2(), f.getStart2());
        this.end2 = genome.getGenomeCoordinate(f.getChr2(), f.getEnd2());
    }

    @Override
    public String getChr1() {
        return "All";
    }

    @Override
    public int getStart1() {
        return this.start1;
    }

    @Override
    public int getEnd1() {
        return this.end1;
    }

    @Override
    public String getChr2() {
        return "All";
    }

    @Override
    public int getStart2() {
        return this.start2;
    }

    @Override
    public int getEnd2() {
        return this.end2;
    }

    @Override
    public boolean isSameChr() {
        return true;
    }

    @Override
    public Color getColor() {
        return this.feature.getColor();
    }

    @Override
    public int getThickness() {
        return this.feature.getThickness();
    }

    @Override
    public void setShape(BedPEShape s) {
        this.feature.setShape(s);
    }

    @Override
    public BedPEShape getShape() {
        return this.feature.getShape();
    }

    @Override
    public String getValueString() {
        return this.feature.getValueString();
    }

    @Override
    public float getScore() {
        return this.feature.getScore();
    }

    public String getContig() {
        return this.feature.getContig();
    }

    public int getStart() {
        return Math.min(this.start1, this.start2);
    }

    public int getEnd() {
        return Math.max(this.end1, this.end2);
    }
}

