/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import org.igv.bedpe.BedPEFeature;
import org.igv.feature.genome.Genome;
import org.igv.ui.color.ColorUtilities;

public class InteractFeature
extends BedPEFeature {
    String chr;
    int start;
    int end;
    private double value;

    public static InteractFeature fromTokens(String[] tokens, Genome genome) {
        if (tokens.length < 12) {
            return null;
        }
        InteractFeature feature = new InteractFeature();
        feature.chr = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
        feature.start = Integer.parseInt(tokens[1]);
        feature.end = Integer.parseInt(tokens[2]);
        feature.name = tokens[3];
        feature.score = Float.parseFloat(tokens[4]);
        feature.value = Double.parseDouble(tokens[5]);
        feature.color = ColorUtilities.stringToColor(tokens[7]);
        feature.chr1 = genome == null ? tokens[8] : genome.getCanonicalChrName(tokens[8]);
        feature.start1 = Integer.parseInt(tokens[9]);
        feature.end1 = Integer.parseInt(tokens[10]);
        feature.chr2 = genome == null ? tokens[13] : genome.getCanonicalChrName(tokens[13]);
        feature.start2 = Integer.parseInt(tokens[14]);
        feature.end2 = Integer.parseInt(tokens[15]);
        return feature;
    }

    @Override
    public String getChr() {
        return this.chr;
    }

    @Override
    public int getStart() {
        return this.start;
    }

    @Override
    public int getEnd() {
        return this.end;
    }
}

