/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.HicFeature;
import org.igv.bedpe.InteractionSource;
import org.igv.feature.genome.Genome;
import org.igv.hic.ContactRecord;
import org.igv.hic.HicFile;
import org.igv.hic.Region;

public class HicSource
implements InteractionSource {
    private final Object genome;
    private final HicFile hicFile;
    private final int binThreshold = 5;

    public HicSource(String path, Genome genome) throws IOException {
        this.hicFile = new HicFile(path, genome);
        this.genome = genome;
    }

    @Override
    public List<BedPE> getFeatures(String chr, int start, int end, double bpPerPixel, String normalization, int maxFeatureCount) throws IOException {
        int binSize = this.hicFile.getBinSize(chr, bpPerPixel);
        List<ContactRecord> records = this.getRecords(chr, start, end, binSize, normalization);
        if (records.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Float> values = new ArrayList<Float>();
        int binMin = Integer.MAX_VALUE;
        int binMax = 0;
        for (ContactRecord rec : records) {
            int b2;
            int b1 = rec.bin1();
            if (Math.abs(b1 - (b2 = rec.bin2())) > this.binThreshold) {
                values.add(Float.valueOf(rec.normCounts()));
            }
            if (b1 < binMin) {
                binMin = b1;
            }
            if (b2 < binMin) {
                binMin = b2;
            }
            if (b1 > binMax) {
                binMax = b1;
            }
            if (b2 <= binMax) continue;
            binMax = b2;
        }
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        values.sort(Collections.reverseOrder());
        int t = Math.min(maxFeatureCount, values.size() - 1);
        double threshold = ((Float)values.get(t)).floatValue();
        double min = ((Float)values.get((int)Math.floor((double)t * 0.05))).floatValue();
        double max = ((Float)values.get((int)Math.floor((double)t * 0.95))).floatValue();
        ArrayList<ContactRecord> thresholdRecords = new ArrayList<ContactRecord>();
        ArrayList<ContactRecord> significantRecords = new ArrayList<ContactRecord>();
        for (ContactRecord rec : records) {
            int bin2;
            int bin1 = rec.bin1();
            if (Math.abs(bin1 - (bin2 = rec.bin2())) <= this.binThreshold) continue;
            float counts = rec.normCounts();
            if ((double)counts > threshold) {
                significantRecords.add(rec);
                continue;
            }
            if ((double)counts != threshold) continue;
            thresholdRecords.add(rec);
        }
        int nThreshold = maxFeatureCount - significantRecords.size();
        if (nThreshold > 0 && !thresholdRecords.isEmpty()) {
            if (thresholdRecords.size() <= nThreshold) {
                significantRecords.addAll(thresholdRecords);
            } else {
                significantRecords.addAll(thresholdRecords.subList(0, nThreshold));
                int reservoirStart = significantRecords.size() - nThreshold;
                for (int i = nThreshold; i < thresholdRecords.size(); ++i) {
                    int j = ThreadLocalRandom.current().nextInt(0, i + 1);
                    if (j >= nThreshold) continue;
                    significantRecords.set(reservoirStart + j, (ContactRecord)thresholdRecords.get(i));
                }
            }
        }
        ArrayList<BedPE> features = new ArrayList<BedPE>();
        String c = this.getChromosomeNameFromGenome(chr);
        for (ContactRecord rec : significantRecords) {
            int start1 = rec.bin1() * binSize;
            int end1 = start1 + binSize;
            int start2 = rec.bin2() * binSize;
            int end2 = start2 + binSize;
            HicFeature f = new HicFeature(c, start1, end1, c, start2, end2, rec.counts(), rec.normCounts());
            int score = max > min ? (int)Math.round(200.0 + Math.min(Math.max(((double)f.getValue() - min) / (max - min), 0.0), 1.0) * 600.0) : 800;
            f.setScore(score);
            features.add(f);
        }
        features.sort(Comparator.comparingInt(a -> a.getStart1()));
        return features;
    }

    @Override
    public List<String> getNormalizationTypes() {
        return this.hicFile.getNormalizationTypes();
    }

    @Override
    public boolean hasNormalizationVector(String type, String chr, double bpPerPixel) {
        return this.hicFile.hasNormalizationVector(type, chr, "BP", this.hicFile.getBinSize(chr, bpPerPixel));
    }

    private List<ContactRecord> getRecords(String chr, int start, int end, int binSize, String normalization) throws IOException {
        Region region1 = new Region(chr, start, end);
        List<ContactRecord> records = this.hicFile.getContactRecords(region1, region1, "BP", binSize, normalization, false);
        if (start > 0) {
            Region adjacent = new Region(chr, Math.max(0, start - (end - start)), start);
            List<ContactRecord> adjacentRecords = this.hicFile.getContactRecords(region1, adjacent, "BP", binSize, "NONE", false);
            records.addAll(adjacentRecords);
        }
        Region adjacent2 = new Region(chr, end, end + (end - start));
        List<ContactRecord> adjacentRecords2 = this.hicFile.getContactRecords(region1, adjacent2, "BP", binSize, "NONE", false);
        records.addAll(adjacentRecords2);
        return records;
    }

    private String getChromosomeNameFromGenome(String chr) {
        try {
            Method m = this.genome.getClass().getMethod("getChromosomeName", String.class);
            Object res = m.invoke(this.genome, chr);
            return res != null ? res.toString() : chr;
        }
        catch (Exception e) {
            return chr;
        }
    }

    public String getNVIString() {
        return this.hicFile.getNVIString();
    }

    public void setNVIString(String nviString) {
        this.hicFile.setNVIString(nviString);
    }

    public HicFile getHicFile() {
        return this.hicFile;
    }
}

