/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.WGFeature;
import org.igv.feature.Chromosome;
import org.igv.feature.LocusScore;
import org.igv.feature.genome.Genome;
import org.igv.track.FeatureSource;
import org.igv.util.Downsampler;
import org.igv.util.FeatureCache;

public class BedPESource
implements FeatureSource<BedPE> {
    public static final int MAX_WG_COUNT = 10000;
    private FeatureCache<BedPE> featureCache;
    private List<BedPE> allFeatures;
    private List<BedPE> wgFeatures;
    private int visibilityWindow;

    public BedPESource(List<BedPE> allFeatures, Genome genome) {
        this.allFeatures = allFeatures;
        this.init(allFeatures, genome);
    }

    @Override
    public Iterator getFeatures(String chr, int start, int end) throws IOException {
        if (chr.equals("All")) {
            return this.wgFeatures.iterator();
        }
        return this.featureCache.getFeatures(chr, start, end).iterator();
    }

    @Override
    public int getFeatureWindowSize() {
        return this.visibilityWindow;
    }

    private void init(List<BedPE> featureList, Genome genome) {
        this.featureCache = new FeatureCache<BedPE>(featureList, 50);
        this.wgFeatures = this.createWGFeatures(featureList, genome);
        this.allFeatures = featureList;
        HashMap<String, Integer> featureCounts = new HashMap<String, Integer>();
        for (BedPE f : featureList) {
            int count = featureCounts.containsKey(f.getChr()) ? (Integer)featureCounts.get(f.getChr()) : 0;
            featureCounts.put(f.getChr(), count + 1);
        }
        int vw = Integer.MAX_VALUE;
        for (Map.Entry entry : featureCounts.entrySet()) {
            String chr = (String)entry.getKey();
            Chromosome chromosome = genome.getChromosome(chr);
            if (chromosome == null) continue;
            double f = 100000.0 / (double)((Integer)entry.getValue()).intValue();
            vw = Math.min(vw, (int)(f * (double)chromosome.getLength()));
        }
        this.visibilityWindow = vw;
    }

    private List<BedPE> createWGFeatures(List<BedPE> features, Genome genome) {
        int size = Math.min(features.size(), 10000);
        ArrayList<BedPE> wgFeatures = new ArrayList<BedPE>(size);
        List<BedPE> sampledFeatures = features.size() < 10000 ? features : BedPESource.downsampleFeatures(features);
        for (BedPE f : sampledFeatures) {
            WGFeature wgFeature = new WGFeature(f, genome);
            wgFeatures.add(wgFeature);
        }
        return wgFeatures;
    }

    public static List<BedPE> downsampleFeatures(List<BedPE> features) {
        if (features.isEmpty()) {
            return Collections.emptyList();
        }
        BedPE maxScoreFeature = features.stream().max(Comparator.comparing(LocusScore::getScore)).get();
        int nBins = maxScoreFeature.getScore() > 0.0f ? 5 : 1;
        double binSize = nBins > 1 ? Math.log10(maxScoreFeature.getScore()) / (double)nBins : 2.147483647E9;
        List[] binnedFeatures = new List[nBins];
        int[] counts = new int[nBins];
        for (int i = 0; i < nBins; ++i) {
            binnedFeatures[i] = new ArrayList();
            counts[i] = 0;
        }
        for (BedPE f : features) {
            if (f.isComplement()) continue;
            int bin = f.getScore() <= 0.0f ? 0 : (int)Math.min((double)(nBins - 1), Math.floor(Math.log10(f.getScore()) / binSize));
            binnedFeatures[bin].add(f);
            int n = bin;
            counts[n] = counts[n] + 1;
        }
        int featuresPerBin = 10000 / nBins;
        ArrayList<BedPE> sampledFeatures = new ArrayList<BedPE>(10000);
        for (int i = 0; i < nBins; ++i) {
            List bfs = binnedFeatures[i];
            sampledFeatures.addAll(Arrays.asList(new Downsampler<BedPE>().sample((BedPE[])bfs.toArray(BedPE[]::new), featuresPerBin)));
        }
        if (maxScoreFeature != null) {
            sampledFeatures.add(maxScoreFeature);
        }
        return sampledFeatures;
    }
}

