/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.codecs.variants.vcf.vcfv4_0;

import htsjdk.beta.codecs.variants.vcf.VCFCodec;
import htsjdk.beta.codecs.variants.vcf.VCFDecoder;
import htsjdk.beta.codecs.variants.vcf.VCFEncoder;
import htsjdk.beta.codecs.variants.vcf.vcfv4_0.VCFDecoderV4_0;
import htsjdk.beta.codecs.variants.vcf.vcfv4_0.VCFEncoderV4_0;
import htsjdk.beta.exception.HtsjdkUnsupportedOperationException;
import htsjdk.beta.io.bundle.Bundle;
import htsjdk.beta.plugin.HtsVersion;
import htsjdk.beta.plugin.variants.VariantsDecoderOptions;
import htsjdk.beta.plugin.variants.VariantsEncoderOptions;
import htsjdk.utils.ValidationUtils;

public class VCFCodecV4_0
extends VCFCodec {
    public static final HtsVersion VCF_V40_VERSION = new HtsVersion(4, 0, 0);
    private static final String VCF_V40_MAGIC = "##fileformat=VCFv4.0";

    @Override
    public HtsVersion getVersion() {
        return VCF_V40_VERSION;
    }

    public VCFDecoder getDecoder(Bundle inputBundle, VariantsDecoderOptions decoderOptions) {
        ValidationUtils.nonNull(inputBundle, "inputBundle");
        ValidationUtils.nonNull(decoderOptions, "decoderOptions");
        return new VCFDecoderV4_0(inputBundle, decoderOptions);
    }

    public VCFEncoder getEncoder(Bundle outputBundle, VariantsEncoderOptions encoderOptions) {
        ValidationUtils.nonNull(outputBundle, "outputBundle");
        ValidationUtils.nonNull(encoderOptions, "encoderOptions");
        return new VCFEncoderV4_0(outputBundle, encoderOptions);
    }

    @Override
    public boolean runVersionUpgrade(HtsVersion sourceCodecVersion, HtsVersion targetCodecVersion) {
        throw new HtsjdkUnsupportedOperationException("Version upgrade not yet implemented");
    }

    @Override
    protected String getSignatureString() {
        return VCF_V40_MAGIC;
    }
}

