/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.util.download;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.lang.invoke.CallSite;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.HashMap;
import javax.swing.ProgressMonitor;
import javax.swing.SwingUtilities;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.HttpUtils;

public class Downloader
implements Runnable {
    private static final Logger log = LogManager.getLogger(Downloader.class);
    private static final int MAX_BUFFER_SIZE = 1000000;
    private URL url;
    private File localFile;
    private String tmpName;
    private int downloaded;
    private boolean canceled;
    private final ProgressMonitor monitor;

    public Downloader(URL url, File file, ProgressMonitor monitor) {
        this.url = url;
        this.localFile = file;
        this.tmpName = file + ".download";
        this.monitor = monitor;
        this.canceled = false;
        this.downloaded = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream stream;
        RandomAccessFile file;
        block51: {
            HttpURLConnection connection;
            long contentLength;
            block49: {
                block50: {
                    file = null;
                    stream = null;
                    contentLength = HttpUtils.getInstance().getContentLength(this.url);
                    if (contentLength < 1L) {
                        // empty if block
                    }
                    HashMap<String, CallSite> requestProperties = new HashMap<String, CallSite>();
                    requestProperties.put("Range", (CallSite)((Object)("bytes=" + this.downloaded + "-" + this.downloaded + "1000000")));
                    connection = HttpUtils.getInstance().openConnection(this.url, null);
                    connection.connect();
                    int responseCode = connection.getResponseCode();
                    if (responseCode >= 200 && responseCode < 300) break block49;
                    MessageUtils.showMessage("Error downloading " + this.url + ". Response code: " + responseCode);
                    if (this.monitor == null) break block50;
                    SwingUtilities.invokeLater(() -> this.monitor.close());
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.canceled) {
                    new File(this.tmpName).delete();
                } else {
                    try {
                        Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e) {
                        log.error("Error renaming download file " + this.tmpName, e);
                    }
                }
                return;
            }
            try {
                byte[] buffer;
                int read;
                file = new RandomAccessFile(this.tmpName, "rw");
                file.seek(this.downloaded);
                stream = connection.getInputStream();
                while ((long)this.downloaded < contentLength && (read = stream.read(buffer = contentLength - (long)this.downloaded > 1000000L ? new byte[1000000] : new byte[(int)(contentLength - (long)this.downloaded)])) != -1) {
                    file.write(buffer, 0, read);
                    this.downloaded += read;
                    int percent = (int)(100.0 * (double)this.downloaded / (double)contentLength);
                    if (this.monitor == null) continue;
                    if (this.monitor.isCanceled()) {
                        this.canceled = true;
                        break;
                    }
                    SwingUtilities.invokeLater(() -> {
                        this.monitor.setProgress(percent);
                        this.monitor.setNote(this.downloaded / 1000 + " of " + contentLength / 1000L + " kb");
                    });
                }
                file.close();
                if (this.monitor == null) break block51;
            }
            catch (Exception e3) {
                block52: {
                    try {
                        log.error("Error downloading " + this.url, e3);
                        if (this.monitor == null) break block52;
                    }
                    catch (Throwable throwable) {
                        if (this.monitor != null) {
                            SwingUtilities.invokeLater(() -> this.monitor.close());
                        }
                        if (file != null) {
                            try {
                                file.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        if (this.canceled) {
                            new File(this.tmpName).delete();
                        } else {
                            try {
                                Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                            }
                            catch (IOException e2) {
                                log.error("Error renaming download file " + this.tmpName, e2);
                            }
                        }
                        throw throwable;
                    }
                    SwingUtilities.invokeLater(() -> this.monitor.close());
                }
                if (file != null) {
                    try {
                        file.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                if (stream != null) {
                    try {
                        stream.close();
                    }
                    catch (Exception e3) {
                        // empty catch block
                    }
                }
                if (this.canceled) {
                    new File(this.tmpName).delete();
                } else {
                    try {
                        Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                    }
                    catch (IOException e4) {
                        log.error("Error renaming download file " + this.tmpName, e4);
                    }
                }
            }
            SwingUtilities.invokeLater(() -> this.monitor.close());
        }
        if (file != null) {
            try {
                file.close();
            }
            catch (Exception contentLength) {
                // empty catch block
            }
        }
        if (stream != null) {
            try {
                stream.close();
            }
            catch (Exception contentLength) {
                // empty catch block
            }
        }
        if (this.canceled) {
            new File(this.tmpName).delete();
        } else {
            try {
                Files.move(new File(this.tmpName).toPath(), this.localFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                log.error("Error renaming download file " + this.tmpName, e);
            }
        }
    }

    public static boolean download(URL url, File localFile, Component frame) throws MalformedURLException {
        ProgressMonitor monitor;
        String message = "Downloading " + url.toString();
        int min = 0;
        int max = 100;
        if (IGV.hasInstance()) {
            monitor = new ProgressMonitor(frame, message, "", min, max);
            monitor.setMillisToDecideToPopup(100);
        } else {
            monitor = null;
        }
        Downloader downloader = new Downloader(url, localFile, monitor);
        downloader.run();
        return !downloader.canceled;
    }

    public static void main(String[] args) throws MalformedURLException {
        URL url = HttpUtils.createURL(args[0]);
        String localFile = args[1];
        Component frame = null;
        String message = "Downloading " + url.toString();
        int min = 0;
        int max = 100;
        ProgressMonitor monitor = new ProgressMonitor(frame, message, "", min, max);
        monitor.setMillisToDecideToPopup(100);
        Downloader dl = new Downloader(url, new File(localFile), monitor);
        new Thread(dl).start();
    }
}

