/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mods;

import java.awt.Color;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.broad.igv.logging.LogManager;
import org.broad.igv.logging.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.AlignmentUtils;
import org.broad.igv.sam.mods.BaseModificationSet;
import org.broad.igv.ui.color.PaletteColorTable;

public class BaseModificationUtils {
    private static Logger log = LogManager.getLogger(BaseModificationUtils.class);
    static Map<String, String> codeValues = new HashMap<String, String>();
    static PaletteColorTable modColorPallete;
    static Map<String, Color> modColorMap;
    static Map<String, Color> modColorMap5MC;

    public static String valueString(String modification, byte likelihood) {
        int l = (int)(100.0 * (double)Byte.toUnsignedInt(likelihood) / 255.0);
        return "Base modification: " + (codeValues.containsKey(modification) ? codeValues.get(modification) : "Uknown") + " (" + l + "%)";
    }

    public static List<BaseModificationSet> getBaseModificationSets(String mm, byte[] ml, byte[] sequence, boolean isNegativeStrand) {
        byte[] origSequence = sequence;
        if (isNegativeStrand) {
            sequence = AlignmentUtils.reverseComplementCopy(sequence);
        }
        ArrayList<BaseModificationSet> modificationSets = new ArrayList<BaseModificationSet>();
        String[] mmTokens = mm.split(";");
        int mlIdx = 0;
        for (String mmi : mmTokens) {
            String[] modifications;
            String modificationString;
            String[] tokens = mmi.split(",");
            char base = tokens[0].charAt(0);
            char strand = tokens[0].charAt(1);
            boolean skippedBasesCalled = tokens[0].endsWith(".");
            if (tokens.length == 1) continue;
            String string = modificationString = tokens[0].endsWith(".") || tokens[0].endsWith("?") ? tokens[0].substring(2, tokens[0].length() - 1) : tokens[0].substring(2);
            if (modificationString.length() > 1) {
                if (BaseModificationUtils.isChEBI(modificationString)) {
                    modifications = new String[]{modificationString};
                } else {
                    modifications = new String[modificationString.length()];
                    for (int i = 0; i < modificationString.length(); ++i) {
                        modifications[i] = modificationString.substring(i, i + 1);
                    }
                }
            } else {
                modifications = new String[]{modificationString};
            }
            HashMap likelihoodMap = new HashMap();
            for (String m : modifications) {
                likelihoodMap.put(m, new HashMap());
            }
            int nPositions = tokens.length - 1;
            int idx = 1;
            int skip = Integer.parseInt(tokens[idx++]);
            int matchCount = 0;
            for (int p = 0; p < sequence.length; ++p) {
                byte likelihood;
                String modification;
                int n;
                int n2;
                String[] stringArray;
                int position;
                if (base != 'N' && sequence[p] != base) continue;
                int n3 = position = isNegativeStrand ? sequence.length - 1 - p : p;
                if (matchCount == skip) {
                    stringArray = modifications;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        modification = stringArray[n];
                        likelihood = ml == null ? (byte)-1 : ml[mlIdx++];
                        ((Map)likelihoodMap.get(modification)).put(position, likelihood);
                    }
                    if (idx >= tokens.length) break;
                    skip = Integer.parseInt(tokens[idx++]);
                    matchCount = 0;
                    continue;
                }
                if (skippedBasesCalled) {
                    stringArray = modifications;
                    n2 = stringArray.length;
                    for (n = 0; n < n2; ++n) {
                        modification = stringArray[n];
                        likelihood = 0;
                        ((Map)likelihoodMap.get(modification)).put(position, likelihood);
                    }
                }
                ++matchCount;
            }
            for (String m : modifications) {
                modificationSets.add(new BaseModificationSet(base, strand, m, (Map)likelihoodMap.get(m)));
            }
        }
        return modificationSets;
    }

    public static Color getModColor(String modification, byte likelihood, AlignmentTrack.ColorOption colorOption) {
        Color baseColor = modColorPallete.get(modification);
        int l = Byte.toUnsignedInt(likelihood);
        String key = modification + "--" + l;
        if (AlignmentTrack.ColorOption.BASE_MODIFICATION_5MC == colorOption) {
            if (l > 255) {
                return baseColor;
            }
            if (!modColorMap5MC.containsKey(key)) {
                int alpha = Math.min(255, (int)((float)(l * l) / 64.0f - (float)(4 * l) + 256.0f));
                if (l >= 128) {
                    modColorMap5MC.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha));
                } else {
                    modColorMap5MC.put(key, new Color(baseColor.getBlue(), baseColor.getGreen(), baseColor.getRed(), alpha));
                }
            }
            return modColorMap5MC.get(key);
        }
        if (l > 250) {
            return baseColor;
        }
        double threshold = 256.0f * PreferencesManager.getPreferences().getAsFloat("SAM.BASEMOD_THRESHOLD");
        if ((double)l < threshold) {
            l = 0;
        }
        if (!modColorMap.containsKey(key)) {
            modColorMap.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), l));
        }
        return modColorMap.get(key);
    }

    public static boolean isChEBI(String str) {
        if (str == null) {
            return false;
        }
        int length = str.length();
        if (length == 0) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            if (c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    static {
        codeValues.put("m", "5mC");
        codeValues.put("h", "5hmC");
        codeValues.put("f", "5fC");
        codeValues.put("c", "5caC");
        codeValues.put("g", "5hmU");
        codeValues.put("e", "5fU");
        codeValues.put("b", "5caU");
        codeValues.put("a", "6mA");
        codeValues.put("o", "8xoG");
        codeValues.put("n", "Xao");
        codeValues.put("C", "Unknown C");
        codeValues.put("T", "Unknown T");
        codeValues.put("A", "Unknown A");
        codeValues.put("G", "Unknown G");
        codeValues.put("N", "Unknown");
        modColorPallete = new PaletteColorTable(new Color(132, 178, 158));
        modColorPallete.put("m", Color.red);
        modColorPallete.put("h", new Color(11, 132, 165));
        modColorPallete.put("o", new Color(111, 78, 129));
        modColorPallete.put("f", new Color(246, 200, 95));
        modColorPallete.put("c", new Color(157, 216, 102));
        modColorPallete.put("g", new Color(255, 160, 86));
        modColorPallete.put("e", new Color(141, 221, 208));
        modColorPallete.put("b", new Color(202, 71, 47));
        modColorMap = new HashMap<String, Color>();
        modColorMap5MC = new HashMap<String, Color>();
    }
}

