/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.beta.io;

import htsjdk.beta.exception.HtsjdkIOException;
import htsjdk.io.HtsPath;
import htsjdk.io.IOPath;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;

public class IOPathUtils {
    public static IOPath createTempPath(String prefix, String suffix) {
        try {
            File tempFile = File.createTempFile(prefix, suffix);
            tempFile.deleteOnExit();
            return new HtsPath(tempFile.getAbsolutePath());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(e);
        }
    }

    public static String getStringFromPath(IOPath ioPath) {
        try {
            StringWriter stringWriter = new StringWriter();
            Files.lines(ioPath.toPath(), StandardCharsets.UTF_8).forEach(line -> {
                stringWriter.write((String)line);
                stringWriter.append("\n");
            });
            return stringWriter.toString();
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failed to read from: %s", ioPath.getRawInputString()), e);
        }
    }

    public static void writeStringToPath(IOPath ioPath, String contents) {
        try (BufferedOutputStream bos = new BufferedOutputStream(ioPath.getOutputStream());){
            bos.write(contents.getBytes());
        }
        catch (IOException e) {
            throw new HtsjdkIOException(String.format("Failed to write to: %s", ioPath.getRawInputString()), e);
        }
    }
}

