/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.InsertionMarker;
import org.broad.igv.ui.panel.ReferenceFrame;

public class RenderContext {
    private Graphics2D graphics;
    private Map<Object, Graphics2D> graphicCache;
    private ReferenceFrame referenceFrame;
    private JComponent panel;
    private Rectangle visibleRect;
    private boolean merged = false;
    public transient int translateX;
    private List<InsertionMarker> insertionMarkers;
    public boolean multiframe = false;

    public RenderContext(JComponent panel, Graphics2D graphics, ReferenceFrame referenceFrame, Rectangle visibleRect) {
        this.graphics = graphics;
        this.panel = panel;
        this.graphicCache = new HashMap<Object, Graphics2D>();
        this.referenceFrame = referenceFrame;
        this.visibleRect = visibleRect;
        if (PreferencesManager.getPreferences().getAntiAliasing() && graphics != null) {
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public RenderContext(RenderContext context) {
        this.graphics = context.getGraphics();
        this.graphicCache = new HashMap<Object, Graphics2D>();
        this.referenceFrame = new ReferenceFrame(context.referenceFrame);
        this.panel = context.panel;
        this.visibleRect = new Rectangle(context.visibleRect);
        if (PreferencesManager.getPreferences().getAntiAliasing() && this.graphics != null) {
            this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public void clearGraphicsCache() {
        this.graphicCache.clear();
    }

    public Graphics2D getGraphics2D(Object key) {
        Graphics2D g = this.graphicCache.get(key);
        if (g == null) {
            g = (Graphics2D)this.graphics.create();
            if (PreferencesManager.getPreferences().getAntiAliasing()) {
                g.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            }
            this.graphicCache.put(key, g);
        }
        return g;
    }

    public Graphics2D getGraphic2DForColor(Color color) {
        Graphics2D g = this.getGraphics2D(color);
        g.setColor(color);
        return g;
    }

    public Color getBackgroundColor() {
        return this.panel.getBackground();
    }

    public String getChr() {
        return this.referenceFrame.getChrName();
    }

    public double getOrigin() {
        return this.referenceFrame.getOrigin();
    }

    public double getEndLocation() {
        return this.referenceFrame.getEnd();
    }

    public double getScale() {
        return this.referenceFrame.getScale();
    }

    public Rectangle getVisibleRect() {
        return this.visibleRect;
    }

    public JComponent getPanel() {
        return this.panel;
    }

    public int getZoom() {
        return this.referenceFrame.getZoom();
    }

    public ReferenceFrame getReferenceFrame() {
        return this.referenceFrame;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public void setMerged(boolean merged) {
        this.merged = merged;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.dispose();
    }

    public void dispose() {
        for (Graphics2D g : this.graphicCache.values()) {
            g.dispose();
        }
        this.graphicCache.clear();
    }

    public void setInsertionMarkers(List<InsertionMarker> insertionMarkers) {
        this.insertionMarkers = insertionMarkers;
    }

    public List<InsertionMarker> getInsertionMarkers() {
        return this.insertionMarkers;
    }
}

