/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.CRAMCodec;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.BitOutputStream;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.Map;

public abstract class CRAMEncoding<T> {
    private final EncodingID encodingId;

    protected CRAMEncoding(EncodingID id) {
        this.encodingId = id;
    }

    public EncodingID id() {
        return this.encodingId;
    }

    public EncodingParams toParam() {
        return new EncodingParams(this.id(), this.toByteArray());
    }

    public abstract byte[] toByteArray();

    public abstract CRAMCodec<T> buildCodec(BitInputStream var1, BitOutputStream var2, Map<Integer, ByteArrayInputStream> var3, Map<Integer, ByteArrayOutputStream> var4);

    public CRAMCodec<T> buildReadCodec(BitInputStream coreBlockInputStream, Map<Integer, ByteArrayInputStream> externalBlockInputMap) {
        return this.buildCodec(coreBlockInputStream, null, externalBlockInputMap, null);
    }

    public CRAMCodec<T> buildWriteCodec(BitOutputStream coreBlockOutputStream, Map<Integer, ByteArrayOutputStream> externalBlockOutputMap) {
        return this.buildCodec(null, coreBlockOutputStream, null, externalBlockOutputMap);
    }
}

