/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.session;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.broad.igv.feature.RegionOfInterest;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.lists.GeneList;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.session.Session;
import org.broad.igv.session.SessionElement;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.Track;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TrackFilter;
import org.broad.igv.ui.TrackFilterElement;
import org.broad.igv.ui.panel.FrameManager;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.panel.TrackPanel;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.ResourceLocator;
import org.broad.igv.util.Utilities;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SessionWriter {
    static Logger log = Logger.getLogger(SessionWriter.class);
    Session session;
    private static int CURRENT_VERSION = 8;
    private static final String TRACK_TAG = "Track";
    Document document;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveSession(Session session, File outputFile) throws IOException {
        RuntimeException e;
        if (session == null) {
            e = new RuntimeException("No session found to save!");
            log.error((Object)"Session Management Error", (Throwable)e);
        }
        this.session = session;
        if (outputFile == null) {
            e = new RuntimeException("Can't save session file: " + outputFile);
            log.error((Object)"Session Management Error", (Throwable)e);
        }
        String xmlString = this.createXmlFromSession(session, outputFile);
        try (Writer fileWriter = null;){
            fileWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "UTF8"));
            fileWriter.write(xmlString);
        }
    }

    public String createXmlFromSession(Session session, File outputFile) throws RuntimeException {
        String xmlString = null;
        this.session = session;
        try {
            int nextAutoscaleGroup;
            String groupBy;
            String locus;
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            this.document = documentBuilder.newDocument();
            this.document.setStrictErrorChecking(true);
            Element globalElement = this.document.createElement("Session");
            globalElement.setAttribute("version", String.valueOf(CURRENT_VERSION));
            String genomeId = GenomeManager.getInstance().getGenomeId();
            if (genomeId != null) {
                globalElement.setAttribute("genome", genomeId);
            }
            if ((locus = session.getLocusString()) != null && !FrameManager.isGeneListMode()) {
                globalElement.setAttribute("locus", locus);
            }
            if ((groupBy = IGV.getInstance().getGroupByAttribute()) != null) {
                globalElement.setAttribute("groupTracksBy", groupBy);
            }
            if ((nextAutoscaleGroup = session.getNextAutoscaleGroup()) > 1) {
                globalElement.setAttribute("nextAutoscaleGroup", String.valueOf(nextAutoscaleGroup));
            }
            if (session.isRemoveEmptyPanels()) {
                globalElement.setAttribute("removeEmptyTracks", "true");
            }
            globalElement.setAttribute("hasGeneTrack", "" + IGV.getInstance().hasGeneTrack());
            globalElement.setAttribute("hasSequenceTrack", "" + IGV.getInstance().hasSequenceTrack());
            if (outputFile != null) {
                globalElement.setAttribute("path", outputFile.getAbsolutePath());
            }
            this.writeResources(outputFile, globalElement, this.document);
            this.writePanels(globalElement, this.document);
            this.writePanelLayout(globalElement, this.document);
            this.writeRegionsOfInterest(globalElement, this.document);
            this.writeFilters(session, globalElement, this.document);
            if (FrameManager.isGeneListMode()) {
                this.writeGeneList(globalElement, this.document);
            }
            if (session.getHiddenAttributes() != null && session.getHiddenAttributes().size() > 0) {
                this.writeHiddenAttributes(session, globalElement, this.document);
            }
            this.document.appendChild(globalElement);
            xmlString = Utilities.getString(this.document);
        }
        catch (Exception e) {
            String message = "An error has occurred while trying to create the session!";
            log.error((Object)message, (Throwable)e);
            JOptionPane.showMessageDialog(IGV.getMainFrame(), message);
            throw new RuntimeException(e);
        }
        return xmlString;
    }

    private void writeFilters(Session session, Element globalElement, Document document) {
        TrackFilter trackFilter = session.getFilter();
        if (trackFilter != null) {
            Element filter = document.createElement("Filter");
            filter.setAttribute("name", trackFilter.getName());
            if (IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute("match", "all");
            } else if (!IGV.getInstance().isFilterMatchAll()) {
                filter.setAttribute("match", "any");
            } else {
                filter.setAttribute("match", "all");
            }
            if (IGV.getInstance().isFilterShowAllTracks()) {
                filter.setAttribute("showTracks", "true");
            } else {
                filter.setAttribute("showTracks", "false");
            }
            globalElement.appendChild(filter);
            Iterator iterator = session.getFilter().getFilterElements();
            while (iterator.hasNext()) {
                TrackFilterElement trackFilterElement = (TrackFilterElement)iterator.next();
                Element filterElementElement = document.createElement("FilterElement");
                filterElementElement.setAttribute("item", trackFilterElement.getSelectedItem());
                filterElementElement.setAttribute("operator", trackFilterElement.getComparisonOperator().getValue());
                filterElementElement.setAttribute("value", trackFilterElement.getValue());
                filterElementElement.setAttribute("booleanOperator", trackFilterElement.getBooleanOperator().getValue());
                filter.appendChild(filterElementElement);
            }
        }
    }

    private void writeRegionsOfInterest(Element globalElement, Document document) {
        Collection<RegionOfInterest> regions = this.session.getAllRegionsOfInterest();
        if (regions != null && !regions.isEmpty()) {
            Element regionsElement = document.createElement("Regions");
            for (RegionOfInterest region : regions) {
                Element regionElement = document.createElement("Region");
                regionElement.setAttribute("chromosome", region.getChr());
                regionElement.setAttribute("start", String.valueOf(region.getStart()));
                regionElement.setAttribute("end", String.valueOf(region.getEnd()));
                if (region.getDescription() != null) {
                    regionElement.setAttribute("description", region.getDescription());
                }
                regionsElement.appendChild(regionElement);
            }
            globalElement.appendChild(regionsElement);
        }
    }

    private void writeHiddenAttributes(Session session, Element globalElement, Document document) {
        Element hiddenAttributes = document.createElement("HiddenAttributes");
        for (String attribute : session.getHiddenAttributes()) {
            Element regionElement = document.createElement("Attribute");
            regionElement.setAttribute("name", attribute);
            hiddenAttributes.appendChild(regionElement);
        }
        globalElement.appendChild(hiddenAttributes);
    }

    private void writeGeneList(Element globalElement, Document document) {
        GeneList geneList = this.session.getCurrentGeneList();
        if (geneList != null) {
            Element geneListElement = document.createElement("GeneList");
            geneListElement.setAttribute("name", geneList.getName());
            StringBuffer genes = new StringBuffer();
            for (String gene : geneList.getLoci()) {
                genes.append(gene);
                genes.append("\n");
            }
            geneListElement.setTextContent(genes.toString());
            globalElement.appendChild(geneListElement);
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                Element frameElement = document.createElement("Frame");
                frameElement.setAttribute("name", frame.getName());
                frameElement.setAttribute("chr", frame.getChrName());
                frameElement.setAttribute("start", String.valueOf(frame.getOrigin()));
                frameElement.setAttribute("end", String.valueOf(frame.getEnd()));
                geneListElement.appendChild(frameElement);
            }
        }
    }

    private void writeResources(File outputFile, Element globalElement, Document document) throws IOException {
        Collection<ResourceLocator> resourceLocators = this.getResourceLocatorSet();
        if (resourceLocators != null && !resourceLocators.isEmpty()) {
            Element filesElement = document.createElement("Resources");
            for (ResourceLocator resourceLocator : resourceLocators) {
                boolean useRelative;
                if (!resourceLocator.exists() && resourceLocator.getPath() == null) continue;
                Element dataFileElement = document.createElement("Resource");
                String resourcePath = resourceLocator.getPath();
                if (outputFile != null && (useRelative = PreferencesManager.getPreferences().getAsBoolean("SESSION.RELATIVE_PATH"))) {
                    resourcePath = FileUtils.getRelativePath(outputFile.getAbsolutePath(), resourcePath);
                }
                dataFileElement.setAttribute("path", resourcePath);
                if (resourceLocator.getName() != null) {
                    dataFileElement.setAttribute("name", resourceLocator.getName());
                }
                if (resourceLocator.getDBUrl() != null) {
                    dataFileElement.setAttribute("serverURL", resourceLocator.getDBUrl());
                }
                if (resourceLocator.getTrackInfoURL() != null) {
                    dataFileElement.setAttribute("hyperlink", resourceLocator.getTrackInfoURL());
                }
                if (resourceLocator.getFeatureInfoURL() != null) {
                    dataFileElement.setAttribute("featureURL", resourceLocator.getFeatureInfoURL());
                }
                if (resourceLocator.getDescription() != null) {
                    dataFileElement.setAttribute("description", resourceLocator.getDescription());
                }
                if (resourceLocator.getType() != null) {
                    dataFileElement.setAttribute("type", resourceLocator.getType());
                }
                if (resourceLocator.getIndexPath() != null) {
                    dataFileElement.setAttribute("index", resourceLocator.getIndexPath());
                }
                if (resourceLocator.getCoverage() != null) {
                    dataFileElement.setAttribute("coverage", resourceLocator.getCoverage());
                }
                if (resourceLocator.getMappingPath() != null) {
                    dataFileElement.setAttribute("mapping", resourceLocator.getMappingPath());
                }
                if (resourceLocator.getTrackLine() != null) {
                    dataFileElement.setAttribute("trackLine", resourceLocator.getTrackLine());
                }
                filesElement.appendChild(dataFileElement);
            }
            globalElement.appendChild(filesElement);
        }
    }

    private void writePanels(Element globalElement, Document document) throws DOMException {
        for (TrackPanel trackPanel : IGV.getInstance().getTrackPanels()) {
            List<Track> tracks = trackPanel.getTracks();
            if (tracks == null || tracks.isEmpty()) continue;
            Element panelElement = document.createElement("Panel");
            panelElement.setAttribute("name", trackPanel.getName());
            panelElement.setAttribute("height", String.valueOf(trackPanel.getHeight()));
            panelElement.setAttribute("width", String.valueOf(trackPanel.getWidth()));
            for (Track track : tracks) {
                Element element = document.createElement(TRACK_TAG);
                element.setAttribute("clazz", SessionElement.getXMLClassName(track.getClass()));
                track.marshalXML(document, element);
                if (track.isNumeric() && track.getDataRange() != null) {
                    Element dataRangeElement = document.createElement("DataRange");
                    track.getDataRange().marshalXML(document, dataRangeElement);
                    element.appendChild(dataRangeElement);
                }
                panelElement.appendChild(element);
            }
            globalElement.appendChild(panelElement);
        }
    }

    private void writePanelLayout(Element globalElement, Document document) {
        double[] dividerFractions = IGV.getInstance().getMainPanel().getDividerFractions();
        if (dividerFractions.length > 0) {
            Element panelLayout = document.createElement("PanelLayout");
            globalElement.appendChild(panelLayout);
            StringBuffer locString = new StringBuffer();
            locString.append(String.valueOf(dividerFractions[0]));
            for (int i = 1; i < dividerFractions.length; ++i) {
                locString.append("," + dividerFractions[i]);
            }
            panelLayout.setAttribute("dividerFractions", locString.toString());
        }
    }

    public Collection<ResourceLocator> getResourceLocatorSet() {
        Set<ResourceLocator> loadedAttributeResources;
        ArrayList<ResourceLocator> locators = new ArrayList<ResourceLocator>();
        Set<ResourceLocator> currentTrackFileLocators = IGV.getInstance().getDataResourceLocators();
        if (currentTrackFileLocators != null) {
            for (ResourceLocator locator : currentTrackFileLocators) {
                locators.add(locator);
            }
        }
        if ((loadedAttributeResources = AttributeManager.getInstance().getLoadedResources()) != null) {
            for (ResourceLocator attributeLocator : loadedAttributeResources) {
                locators.add(attributeLocator);
            }
        }
        return locators;
    }
}

