/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.FileDialogUtils;
import org.broad.igv.util.FileUtils;

public class OpenSessionMenuAction
extends MenuAction {
    private static Logger log = Logger.getLogger(OpenSessionMenuAction.class);
    private IGV mainFrame;
    private String sessionFile = null;
    private boolean autoload = false;

    public OpenSessionMenuAction(String label, String sessionFile, IGV mainFrame) {
        super(label);
        this.sessionFile = sessionFile;
        this.mainFrame = mainFrame;
        this.autoload = true;
    }

    public OpenSessionMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.sessionFile == null || !this.autoload) {
            File lastSessionDirectory = PreferencesManager.getPreferences().getLastTrackDirectory();
            File tmpFile = FileDialogUtils.chooseFile("Open Session", lastSessionDirectory, 0);
            if (tmpFile == null) {
                return;
            }
            this.sessionFile = tmpFile.getAbsolutePath();
            PreferencesManager.getPreferences().setLastTrackDirectory(tmpFile.getParentFile());
        }
        this.doRestoreSession();
    }

    public final void doRestoreSession() {
        if (this.sessionFile != null) {
            if (FileUtils.isRemote(this.sessionFile)) {
                boolean merge = false;
                this.mainFrame.doRestoreSession(this.sessionFile, null, merge);
            } else {
                File f = new File(this.sessionFile);
                this.mainFrame.doRestoreSession(f, null);
            }
        }
    }
}

