/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.basepair;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.feature.basepair.BasePairData;
import org.broad.igv.feature.basepair.BasePairFileParser;
import org.broad.igv.feature.basepair.BasePairRenderer;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.session.Persistable;
import org.broad.igv.track.AbstractTrack;
import org.broad.igv.track.RenderContext;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class BasePairTrack
extends AbstractTrack {
    private static Logger log = Logger.getLogger(BasePairTrack.class);
    private BasePairRenderer basePairRenderer = new BasePairRenderer();
    private BasePairData basePairData = new BasePairData();
    Genome genome;
    private RenderOptions renderOptions = new RenderOptions();

    public BasePairTrack(ResourceLocator locator, String id, String name, Genome genome) {
        super(id, name, locator);
        BasePairFileParser.loadData(locator, genome, this.basePairData, this.renderOptions);
        this.genome = genome;
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        return this.basePairData != null;
    }

    @Override
    public void load(ReferenceFrame frame) {
        BasePairFileParser.loadData(this.getResourceLocator(), this.genome, this.basePairData, this.renderOptions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void render(RenderContext context, Rectangle rect) {
        Graphics2D g2d = context.getGraphics();
        Rectangle clip = new Rectangle(g2d.getClip().getBounds());
        g2d.setClip(rect.intersection(clip.getBounds()));
        context.clearGraphicsCache();
        try {
            this.basePairRenderer.draw(this.basePairData, context, rect, this.renderOptions);
            context.clearGraphicsCache();
        }
        finally {
            g2d.setClip(clip);
        }
    }

    private void setRenderOptions(RenderOptions renderOptions) {
        this.renderOptions = renderOptions;
    }

    public RenderOptions getRenderOptions() {
        return this.renderOptions;
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        Element renderElement = document.createElement("BPRenderOptions");
        this.renderOptions.marshalXML(document, renderElement);
        element.appendChild(renderElement);
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        NodeList tmp = element.getElementsByTagName("BPRenderOptions");
        if (tmp.getLength() > 0) {
            Element renderElement = (Element)tmp.item(0);
            this.renderOptions.unmarshalXML(renderElement, version);
        }
    }

    public static class RenderOptions
    implements Persistable {
        public static final String NAME = "BPRenderOptions";
        private ArcDirection arcDirection = ArcDirection.DOWN;
        private List<String> colors = new ArrayList<String>();
        private List<String> colorLabels = new ArrayList<String>();

        public void changeColor(Color currentColor, String currentLabel, Color newColor) {
            String currentColorString = ColorUtilities.colorToString(currentColor);
            String newColorString = ColorUtilities.colorToString(newColor);
            for (int i = 0; i < this.getColors().size(); ++i) {
                String colorString = this.getColors().get(i);
                String label = this.getColorLabels().get(i);
                if (!currentColorString.equals(colorString) || !currentLabel.equals(label)) continue;
                this.setColor(i, newColorString);
            }
        }

        public ArcDirection getArcDirection() {
            return this.arcDirection;
        }

        public void setArcDirection(ArcDirection d) {
            this.arcDirection = d;
        }

        public List<String> getColors() {
            return this.colors;
        }

        public void setColors(List<String> l) {
            this.colors = l;
        }

        public List<String> getColorLabels() {
            return this.colorLabels;
        }

        public void setColorLabels(List<String> l) {
            this.colorLabels = l;
        }

        public String getColor(int i) {
            return this.colors.get(i);
        }

        public void setColor(int i, String s) {
            this.colors.set(i, s);
        }

        public String getColorLabel(int i) {
            return this.colorLabels.get(i);
        }

        public void setColorLabel(int i, String s) {
            this.colorLabels.set(i, s);
        }

        @Override
        public void marshalXML(Document document, Element element) {
            if (this.arcDirection != ArcDirection.DOWN) {
                element.setAttribute("arcDirection", this.arcDirection.toString());
            }
            if (this.colors.size() > 0) {
                for (String c : this.colors) {
                    Element colorElement = document.createElement("colors");
                    colorElement.setTextContent(c);
                    element.appendChild(colorElement);
                }
            }
        }

        @Override
        public void unmarshalXML(Element element, Integer version) {
            NodeList colorList;
            if (element.hasAttribute("arcDirection")) {
                this.arcDirection = ArcDirection.valueOf(element.getAttribute("arcDirection"));
            }
            if ((colorList = element.getElementsByTagName("colors")).getLength() > 0) {
                this.colors = new ArrayList<String>();
                for (int i = 0; i < colorList.getLength(); ++i) {
                    Node node = colorList.item(i);
                    this.colors.add(node.getTextContent());
                }
            }
        }
    }

    public static enum ArcDirection {
        UP,
        DOWN;

    }
}

