/*
 * Decompiled with CFR 0.152.
 */
package org.campagnelab.goby.alignments;

import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.logging.ProgressLogger;
import java.io.IOException;
import org.campagnelab.goby.alignments.AlignmentWriter;
import org.campagnelab.goby.alignments.Alignments;
import org.campagnelab.goby.reads.ReadSet;
import org.campagnelab.goby.reads.ReadsLoader;
import org.campagnelab.goby.reads.SequenceDigests;
import org.campagnelab.goby.reads.SequenceEncoder;

public class ScanReferenceSequence {
    private byte[] sequence;
    private ProgressLogger progress;
    private int readLength;
    private long trueMatches;
    private byte[] byteBuffer;
    private SequenceDigests[] readDigests;
    private ObjectList<byte[]> compressedReads;
    private long potentialMatches;
    private int[] hitsPerRead;
    private final SequenceEncoder encoder = new SequenceEncoder();
    private int referenceSequenceIndex;
    private AlignmentWriter writer;
    private ReadSet readIndexFilter;
    public Int2IntMap matchingReferenceIndex = new Int2IntOpenHashMap();
    private String alphabet;
    private int readOccurenceThreshold;

    public void setWriter(AlignmentWriter writer) {
        this.writer = writer;
    }

    public void setAlphabet(String alphabet) {
        this.alphabet = alphabet;
    }

    public void setReadOccurenceThreshold(int readOccurenceThreshold) {
        this.readOccurenceThreshold = readOccurenceThreshold;
    }

    public void set(int referenceSequenceIndex, byte[] sequence, ReadsLoader loader, int[] hitsPerRead) {
        this.sequence = sequence;
        this.byteBuffer = loader.getByteBuffer();
        this.readDigests = loader.getDigests();
        this.compressedReads = loader.getCompressedReads();
        this.hitsPerRead = hitsPerRead;
        this.referenceSequenceIndex = referenceSequenceIndex;
    }

    public long getTrueMatches() {
        return this.trueMatches;
    }

    public long getPotentialMatches() {
        return this.potentialMatches;
    }

    public ScanReferenceSequence scan() throws IOException {
        this.progress.itemsName = "x 1000 positions";
        int length = this.sequence.length;
        int end = length - this.readLength;
        for (int referencePosition = 0; referencePosition < end; ++referencePosition) {
            for (SequenceDigests sd : this.readDigests) {
                int[] readIndices;
                int digest = sd.digestDirectStrandOnly(this.sequence, referencePosition, this.readLength);
                for (int readIndex : readIndices = sd.getReadIndices(digest)) {
                    byte[] readCompressedSeq;
                    if (readIndex == -1) continue;
                    if (this.hitsPerRead[readIndex] <= this.readOccurenceThreshold && sd.confirmMatch(readCompressedSeq = (byte[])this.compressedReads.get(readIndex), this.sequence, referencePosition, this.readLength)) {
                        ++this.trueMatches;
                        int n = readIndex;
                        this.hitsPerRead[n] = this.hitsPerRead[n] + 1;
                        if (this.hitsPerRead[readIndex] > this.readOccurenceThreshold) {
                            sd.remove(digest, readIndex);
                        } else {
                            Alignments.AlignmentEntry.Builder builder = Alignments.AlignmentEntry.newBuilder();
                            builder.setQueryIndex(readIndex);
                            builder.setTargetIndex(this.referenceSequenceIndex);
                            builder.setPosition(referencePosition);
                            builder.setMatchingReverseStrand(!sd.isMatchingPositiveStrand());
                            builder.setScore(this.readLength);
                            builder.setNumberOfIndels(0);
                            builder.setQueryAlignedLength(this.readLength);
                            int multiplicity = 1;
                            if (this.readIndexFilter != null) {
                                multiplicity = this.readIndexFilter.getMultiplicity(readIndex);
                            }
                            builder.setMultiplicity(multiplicity);
                            Alignments.AlignmentEntry entry = builder.build();
                            this.writer.appendEntry(entry);
                        }
                    }
                    ++this.potentialMatches;
                }
            }
            if (referencePosition % 1000 != 1) continue;
            this.progress.lightUpdate();
        }
        return this;
    }

    public void setProgress(ProgressLogger progress) {
        this.progress = progress;
    }

    public void setReadLength(int readLength) {
        this.readLength = readLength;
    }

    public void setReadIndexFilter(ReadSet readIndexFilter) {
        this.readIndexFilter = readIndexFilter;
    }
}

