/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import java.util.Objects;

public class GenomeListItem {
    private String displayableName;
    private String path;
    private String id;
    private boolean hasDownloadedSequence = false;
    private long lastModified = 0L;
    public static final GenomeListItem DOWNLOAD_ITEM = new GenomeListItem("Download...", "", "Download...");

    public GenomeListItem(String displayableName, String path, String id) {
        this.displayableName = displayableName;
        this.path = path;
        this.id = id;
    }

    public static GenomeListItem fromString(String str) {
        String[] tokens = str.split("\t");
        GenomeListItem item = new GenomeListItem(tokens[1], tokens[2], tokens[0]);
        item.hasDownloadedSequence = Boolean.parseBoolean(tokens[3]);
        return item;
    }

    public String getDisplayableName() {
        return this.displayableName;
    }

    public String getId() {
        return this.id;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getPath() {
        return this.path;
    }

    public String toString() {
        return this.getDisplayableName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GenomeListItem that = (GenomeListItem)o;
        if (this.id != null ? !this.id.equals(that.id) : that.id != null) {
            return false;
        }
        return !(this.path != null ? !this.path.equals(that.path) : that.path != null);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.id);
    }

    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    public long getLastModified() {
        return this.lastModified;
    }
}

