/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.InputResource;
import htsjdk.samtools.seekablestream.SeekablePathStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.sra.SRAAccession;
import htsjdk.samtools.util.Lazy;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.function.Function;
import java.util.function.Supplier;

class PathInputResource
extends InputResource {
    final Path pathResource;
    final Function<SeekableByteChannel, SeekableByteChannel> wrapper;
    final Lazy<SeekableStream> lazySeekableStream = new Lazy<SeekableStream>(new Supplier<SeekableStream>(){

        @Override
        public SeekableStream get() {
            try {
                return new SeekablePathStream(PathInputResource.this.pathResource, PathInputResource.this.wrapper);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
    });

    PathInputResource(Path pathResource) {
        this(pathResource, Function.identity());
    }

    PathInputResource(Path pathResource, Function<SeekableByteChannel, SeekableByteChannel> wrapper) {
        super(InputResource.Type.PATH);
        this.pathResource = pathResource;
        this.wrapper = wrapper;
    }

    @Override
    public File asFile() {
        try {
            return this.asPath().toFile();
        }
        catch (UnsupportedOperationException e) {
            return null;
        }
    }

    @Override
    public Path asPath() {
        return this.pathResource;
    }

    @Override
    public URL asUrl() {
        try {
            return this.asPath().toUri().toURL();
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    @Override
    public SeekableStream asUnbufferedSeekableStream() {
        return this.lazySeekableStream.get();
    }

    @Override
    public InputStream asUnbufferedInputStream() {
        return this.asUnbufferedSeekableStream();
    }

    @Override
    public SRAAccession asSRAAccession() {
        return null;
    }
}

