/*
 * Decompiled with CFR 0.152.
 */
package it.unimi.dsi.bits;

import it.unimi.dsi.bits.BitVector;
import it.unimi.dsi.bits.PrefixCoderTransformationStrategy;
import it.unimi.dsi.compression.HuTuckerCodec;
import it.unimi.dsi.fastutil.chars.Char2IntOpenHashMap;

public class HuTuckerTransformationStrategy
extends PrefixCoderTransformationStrategy {
    private static final long serialVersionUID = 1L;

    public HuTuckerTransformationStrategy(Iterable<? extends CharSequence> iterable, boolean prefixFree) {
        this(HuTuckerTransformationStrategy.getCoder(iterable, prefixFree), prefixFree);
    }

    protected HuTuckerTransformationStrategy(PrefixCoderTransformationStrategy huTuckerTransformationStrategy) {
        super(huTuckerTransformationStrategy);
    }

    protected HuTuckerTransformationStrategy(Object[] a, boolean prefixFree) {
        super((BitVector[])a[0], (Char2IntOpenHashMap)a[1], prefixFree);
    }

    private static Object[] getCoder(Iterable<? extends CharSequence> iterable, boolean prefixFree) {
        long[] frequency = new long[65536];
        int maxWordLength = 0;
        int n = 0;
        for (CharSequence charSequence : iterable) {
            maxWordLength = Math.max(charSequence.length(), maxWordLength);
            int j = charSequence.length();
            while (j-- != 0) {
                char c = charSequence.charAt(j);
                frequency[c] = frequency[c] + 1L;
            }
            ++n;
        }
        int count = prefixFree ? 1 : 0;
        int i = frequency.length;
        while (i-- != 0) {
            if (frequency[i] == 0L) continue;
            ++count;
        }
        long[] packedFrequency = new long[count];
        Char2IntOpenHashMap char2symbol = new Char2IntOpenHashMap(count);
        int i2 = frequency.length;
        int k = count;
        while (i2-- != 0) {
            if (frequency[i2] == 0L) continue;
            packedFrequency[--k] = frequency[i2];
            char2symbol.put((char)i2, k);
        }
        if (prefixFree) {
            packedFrequency[0] = n;
        }
        return new Object[]{new HuTuckerCodec(packedFrequency).coder().codeWords(), char2symbol};
    }

    @Override
    public PrefixCoderTransformationStrategy copy() {
        return new HuTuckerTransformationStrategy(this);
    }
}

