/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.cram.CRAIIndex;
import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.IOException;
import java.io.OutputStream;

public class CRAIEntry
implements Comparable<CRAIEntry> {
    private final int sequenceId;
    private final int alignmentStart;
    private final int alignmentSpan;
    private final long containerStartByteOffset;
    private final int sliceByteOffsetFromCompressionHeaderStart;
    private final int sliceByteSize;
    private static final int CRAI_INDEX_COLUMNS = 6;
    private static final String ENTRY_FORMAT = "%d\t%d\t%d\t%d\t%d\t%d";

    public CRAIEntry(int sequenceId, int alignmentStart, int alignmentSpan, long containerStartByteOffset, int sliceByteOffsetFromCompressionHeaderStart, int sliceByteSize) {
        if (sequenceId == -2) {
            throw new CRAMException("Cannot directly index a multiref slice.  Index by its constituent references instead.");
        }
        this.sequenceId = sequenceId;
        this.alignmentStart = alignmentStart;
        this.alignmentSpan = alignmentSpan;
        this.containerStartByteOffset = containerStartByteOffset;
        this.sliceByteOffsetFromCompressionHeaderStart = sliceByteOffsetFromCompressionHeaderStart;
        this.sliceByteSize = sliceByteSize;
    }

    public CRAIEntry(String line) {
        String[] chunks = line.split("\t");
        if (chunks.length != 6) {
            throw new CRAIIndex.CRAIIndexException("Malformed CRAI index entry: expecting 6 columns but got " + chunks.length);
        }
        try {
            this.sequenceId = Integer.parseInt(chunks[0]);
            this.alignmentStart = Integer.parseInt(chunks[1]);
            this.alignmentSpan = Integer.parseInt(chunks[2]);
            this.containerStartByteOffset = Long.parseLong(chunks[3]);
            this.sliceByteOffsetFromCompressionHeaderStart = Integer.parseInt(chunks[4]);
            this.sliceByteSize = Integer.parseInt(chunks[5]);
        }
        catch (NumberFormatException e) {
            throw new CRAIIndex.CRAIIndexException(e);
        }
    }

    public void writeToStream(OutputStream os) {
        try {
            os.write(this.serializeToString().getBytes());
            os.write(10);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    private String serializeToString() {
        return String.format(ENTRY_FORMAT, this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerStartByteOffset, this.sliceByteOffsetFromCompressionHeaderStart, this.sliceByteSize);
    }

    public String toString() {
        return this.serializeToString();
    }

    @Override
    public int compareTo(CRAIEntry other) {
        if (this.sequenceId != other.sequenceId) {
            if (this.sequenceId == -1) {
                return 1;
            }
            if (other.sequenceId == -1) {
                return -1;
            }
            return Integer.compare(this.sequenceId, other.sequenceId);
        }
        if (this.sequenceId != -1 && this.alignmentStart != other.alignmentStart) {
            return Integer.compare(this.alignmentStart, other.alignmentStart);
        }
        if (this.containerStartByteOffset != other.containerStartByteOffset) {
            return Long.compare(this.containerStartByteOffset, other.containerStartByteOffset);
        }
        return Long.compare(this.sliceByteOffsetFromCompressionHeaderStart, other.sliceByteOffsetFromCompressionHeaderStart);
    }

    public static boolean intersect(CRAIEntry e0, CRAIEntry e1) {
        if (e0.sequenceId != e1.sequenceId) {
            return false;
        }
        if (e0.sequenceId == -1) {
            return false;
        }
        int a0 = e0.alignmentStart;
        int b0 = a0 + e0.alignmentSpan;
        int a1 = e1.alignmentStart;
        int b1 = a1 + e1.alignmentSpan;
        return Math.abs(a0 + b0 - a1 - b1) < e0.alignmentSpan + e1.alignmentSpan;
    }

    public int getSequenceId() {
        return this.sequenceId;
    }

    public int getAlignmentStart() {
        return this.alignmentStart;
    }

    public int getAlignmentSpan() {
        return this.alignmentSpan;
    }

    public long getContainerStartByteOffset() {
        return this.containerStartByteOffset;
    }

    public int getSliceByteOffsetFromCompressionHeaderStart() {
        return this.sliceByteOffsetFromCompressionHeaderStart;
    }

    public int getSliceByteSize() {
        return this.sliceByteSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CRAIEntry entry = (CRAIEntry)o;
        if (this.sequenceId != entry.sequenceId) {
            return false;
        }
        if (this.alignmentStart != entry.alignmentStart) {
            return false;
        }
        if (this.alignmentSpan != entry.alignmentSpan) {
            return false;
        }
        if (this.containerStartByteOffset != entry.containerStartByteOffset) {
            return false;
        }
        if (this.sliceByteOffsetFromCompressionHeaderStart != entry.sliceByteOffsetFromCompressionHeaderStart) {
            return false;
        }
        return this.sliceByteSize == entry.sliceByteSize;
    }

    public int hashCode() {
        int result = this.sequenceId;
        result = 31 * result + this.alignmentStart;
        result = 31 * result + this.alignmentSpan;
        result = 31 * result + (int)(this.containerStartByteOffset ^ this.containerStartByteOffset >>> 32);
        result = 31 * result + this.sliceByteOffsetFromCompressionHeaderStart;
        result = 31 * result + this.sliceByteSize;
        return result;
    }
}

