/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.cram;

import htsjdk.samtools.SAMSequenceRecord;
import htsjdk.samtools.cram.ref.CRAMReferenceSource;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.broad.igv.event.GenomeChangeEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.feature.Chromosome;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.cram.ReferenceDiskCache;
import org.broad.igv.ui.IGV;
import org.broad.igv.util.ObjectCache;

public class IGVReferenceSource
implements CRAMReferenceSource {
    private static Logger log = Logger.getLogger(IGVReferenceSource.class);
    static ObjectCache<String, byte[]> cachedSequences = new ObjectCache(2);
    static GenomeChangeListener genomeChangeListener = new GenomeChangeListener();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getReferenceBases(SAMSequenceRecord record, boolean tryNameVariants) {
        String name = record.getSequenceName();
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        String chrName = currentGenome.getCanonicalChrName(name);
        Chromosome chromosome = currentGenome.getChromosome(chrName);
        byte[] bases = cachedSequences.get(chrName);
        if (bases == null) {
            try {
                boolean cacheOnDisk;
                boolean bl = cacheOnDisk = currentGenome.sequenceIsRemote() && PreferencesManager.getPreferences().getAsBoolean("CRAM.CACHE_SEQUENCES");
                if (cacheOnDisk && (bases = this.readBasesFromCache(currentGenome, chrName)) != null && bases.length != chromosome.getLength()) {
                    log.error((Object)"CRAM reference cache mismatch");
                    ReferenceDiskCache.deleteCache(currentGenome.getId(), chrName);
                    bases = null;
                }
                if (bases == null) {
                    if (IGV.hasInstance()) {
                        IGV.getInstance().setStatusBarMessage("Loading sequence");
                    }
                    bases = currentGenome.getSequence(chrName, 0, chromosome.getLength(), false);
                    for (int i = 0; i < bases.length; ++i) {
                        if (bases[i] < 97) continue;
                        int n = i;
                        bases[n] = (byte)(bases[n] - 32);
                    }
                    if (cacheOnDisk) {
                        this.saveBasesToCache(currentGenome, chrName, bases);
                    }
                }
                cachedSequences.put(chrName, bases);
            }
            finally {
                if (IGV.hasInstance()) {
                    IGV.getInstance().setStatusBarMessage("");
                }
            }
        }
        return bases;
    }

    private void saveBasesToCache(Genome currentGenome, String chrName, byte[] bases) {
        try {
            ReferenceDiskCache.saveSequence(currentGenome.getId(), chrName, bases);
        }
        catch (IOException e) {
            log.error((Object)"Error saving cached sequence ", (Throwable)e);
        }
    }

    private byte[] readBasesFromCache(Genome currentGenome, String chrName) {
        try {
            return ReferenceDiskCache.readSequence(currentGenome.getId(), chrName);
        }
        catch (IOException e) {
            log.error((Object)"Error reading cached sequence ", (Throwable)e);
            return null;
        }
    }

    static {
        IGVEventBus.getInstance().subscribe(GenomeChangeEvent.class, genomeChangeListener);
    }

    public static class GenomeChangeListener
    implements IGVEventObserver {
        @Override
        public void receiveEvent(Object event) {
            cachedSequences.clear();
        }
    }
}

