/*
 * Decompiled with CFR 0.152.
 */
package com.martiansoftware.jsap;

import com.martiansoftware.jsap.ExceptionMap;
import com.martiansoftware.jsap.UnspecifiedParameterException;
import java.awt.Color;
import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class JSAPResult
implements ExceptionMap {
    private Map allResults = new HashMap();
    private Map qualifiedSwitches = null;
    private Map allExceptions = new LinkedHashMap();
    private List chronologicalErrorMessages = new LinkedList();
    private Set userSpecifiedIDs = null;
    private boolean valuesFromUser = false;

    protected JSAPResult() {
        this.qualifiedSwitches = new HashMap();
        this.userSpecifiedIDs = new HashSet();
    }

    void setValuesFromUser(boolean valuesFromUser) {
        this.valuesFromUser = valuesFromUser;
    }

    public boolean contains(String id) {
        return this.allResults.containsKey(id);
    }

    public boolean userSpecified(String id) {
        return this.userSpecifiedIDs.contains(id);
    }

    protected void add(String id, List values) {
        List al = null;
        if (this.allResults.containsKey(id)) {
            al = (List)this.allResults.get(id);
        } else {
            al = new ArrayList();
            this.allResults.put(id, al);
        }
        al.addAll(values);
        if (this.valuesFromUser) {
            this.userSpecifiedIDs.add(id);
        }
    }

    @Override
    public void addException(String id, Exception exception) {
        List<Exception> el = null;
        if (this.allExceptions.containsKey(id)) {
            el = (List)this.allExceptions.get(id);
        } else {
            el = new ArrayList();
            this.allExceptions.put(id, el);
        }
        el.add(exception);
        this.chronologicalErrorMessages.add(exception.getMessage());
    }

    public Object getObject(String id) {
        Object result = null;
        List al = (List)this.allResults.get(id);
        if (al != null && al.size() > 0) {
            result = al.get(0);
        }
        return result;
    }

    public Object[] getObjectArray(String id) {
        ArrayList al = (ArrayList)this.allResults.get(id);
        if (al == null) {
            al = new ArrayList(0);
        }
        return al.toArray();
    }

    public Object[] getObjectArray(String id, Object[] a) {
        ArrayList al = (ArrayList)this.allResults.get(id);
        if (al == null) {
            al = new ArrayList();
        }
        return al.toArray(a);
    }

    public boolean getBoolean(String id) {
        Boolean b = (Boolean)this.qualifiedSwitches.get(id);
        if (b == null) {
            if (!this.contains(id)) {
                throw new UnspecifiedParameterException(id);
            }
            b = (Boolean)this.getObject(id);
        }
        return b;
    }

    public boolean getBoolean(String id, boolean defaultValue) {
        Boolean b = (Boolean)this.qualifiedSwitches.get(id);
        if (b == null) {
            b = (Boolean)this.getObject(id);
        }
        return b == null ? defaultValue : b;
    }

    public boolean[] getBooleanArray(String id) {
        Boolean[] tmp = (Boolean[])this.getObjectArray(id, new Boolean[0]);
        int tmplength = tmp.length;
        boolean[] result = new boolean[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public int getInt(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return (Integer)this.getObject(id);
    }

    public int getInt(String id, int defaultValue) {
        Integer result = (Integer)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public String getQualifiedSwitchValue(String id) {
        Object result = null;
        List al = (List)this.allResults.get(id);
        if (al != null && al.size() == 2) {
            result = al.get(1);
        }
        return result;
    }

    public int[] getIntArray(String id) {
        Integer[] tmp = (Integer[])this.getObjectArray(id, new Integer[0]);
        int tmplength = tmp.length;
        int[] result = new int[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public long getLong(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return (Long)this.getObject(id);
    }

    public long getLong(String id, long defaultValue) {
        Long result = (Long)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public long[] getLongArray(String id) {
        Long[] tmp = (Long[])this.getObjectArray(id, new Long[0]);
        int tmplength = tmp.length;
        long[] result = new long[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public byte getByte(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return (Byte)this.getObject(id);
    }

    public byte getByte(String id, byte defaultValue) {
        Byte result = (Byte)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public byte[] getByteArray(String id) {
        Byte[] tmp = (Byte[])this.getObjectArray(id, new Byte[0]);
        int tmplength = tmp.length;
        byte[] result = new byte[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public char getChar(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return ((Character)this.getObject(id)).charValue();
    }

    public char getChar(String id, char defaultValue) {
        Character result = (Character)this.getObject(id);
        return result == null ? defaultValue : result.charValue();
    }

    public char[] getCharArray(String id) {
        Character[] tmp = (Character[])this.getObjectArray(id, new Character[0]);
        int tmplength = tmp.length;
        char[] result = new char[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i].charValue();
        }
        return result;
    }

    public short getShort(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return (Short)this.getObject(id);
    }

    public short getShort(String id, short defaultValue) {
        Short result = (Short)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public short[] getShortArray(String id) {
        Short[] tmp = (Short[])this.getObjectArray(id, new Short[0]);
        int tmplength = tmp.length;
        short[] result = new short[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public double getDouble(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return (Double)this.getObject(id);
    }

    public double getDouble(String id, double defaultValue) {
        Double result = (Double)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public double[] getDoubleArray(String id) {
        Double[] tmp = (Double[])this.getObjectArray(id, new Double[0]);
        int tmplength = tmp.length;
        double[] result = new double[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i];
        }
        return result;
    }

    public float getFloat(String id) {
        if (!this.contains(id)) {
            throw new UnspecifiedParameterException(id);
        }
        return ((Float)this.getObject(id)).floatValue();
    }

    public float getFloat(String id, float defaultValue) {
        Float result = (Float)this.getObject(id);
        return result == null ? defaultValue : result.floatValue();
    }

    public float[] getFloatArray(String id) {
        Float[] tmp = (Float[])this.getObjectArray(id, new Float[0]);
        int tmplength = tmp.length;
        float[] result = new float[tmplength];
        for (int i = 0; i < tmplength; ++i) {
            result[i] = tmp[i].floatValue();
        }
        return result;
    }

    public String getString(String id) {
        return (String)this.getObject(id);
    }

    public String getString(String id, String defaultValue) {
        String result = (String)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public String[] getStringArray(String id) {
        return (String[])this.getObjectArray(id, new String[0]);
    }

    public BigDecimal getBigDecimal(String id) {
        return (BigDecimal)this.getObject(id);
    }

    public BigDecimal getBigDecimal(String id, BigDecimal defaultValue) {
        BigDecimal result = (BigDecimal)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public BigDecimal[] getBigDecimalArray(String id) {
        return (BigDecimal[])this.getObjectArray(id, new BigDecimal[0]);
    }

    public BigInteger getBigInteger(String id) {
        return (BigInteger)this.getObject(id);
    }

    public BigInteger getBigInteger(String id, BigInteger defaultValue) {
        BigInteger result = (BigInteger)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public BigInteger[] getBigIntegerArray(String id) {
        return (BigInteger[])this.getObjectArray(id, new BigInteger[0]);
    }

    public Class getClass(String id) {
        return (Class)this.getObject(id);
    }

    public Class getClass(String id, Class defaultValue) {
        Class result = (Class)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public Class[] getClassArray(String id) {
        return (Class[])this.getObjectArray(id, new Class[0]);
    }

    public InetAddress getInetAddress(String id) {
        return (InetAddress)this.getObject(id);
    }

    public InetAddress getInetAddress(String id, InetAddress defaultValue) {
        InetAddress result = (InetAddress)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public InetAddress[] getInetAddressArray(String id) {
        return (InetAddress[])this.getObjectArray(id, new InetAddress[0]);
    }

    public Package getPackage(String id) {
        return (Package)this.getObject(id);
    }

    public Package getPackage(String id, Package defaultValue) {
        Package result = (Package)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public Package[] getPackageArray(String id) {
        return (Package[])this.getObjectArray(id, new Package[0]);
    }

    public URL getURL(String id) {
        return (URL)this.getObject(id);
    }

    public URL getURL(String id, URL defaultValue) {
        URL result = (URL)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public URL[] getURLArray(String id) {
        return (URL[])this.getObjectArray(id, new URL[0]);
    }

    public Color getColor(String id) {
        return (Color)this.getObject(id);
    }

    public File getFile(String id) {
        return (File)this.getObject(id);
    }

    public Color getColor(String id, Color defaultValue) {
        Color result = (Color)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public File getFile(String id, File defaultValue) {
        File result = (File)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public Color[] getColorArray(String id) {
        return (Color[])this.getObjectArray(id, new Color[0]);
    }

    public File[] getFileArray(String id) {
        return (File[])this.getObjectArray(id, new File[0]);
    }

    public Date getDate(String id) {
        return (Date)this.getObject(id);
    }

    public Date getDate(String id, Date defaultValue) {
        Date result = (Date)this.getObject(id);
        return result == null ? defaultValue : result;
    }

    public Date[] getDateArray(String id) {
        return (Date[])this.getObjectArray(id, new Date[0]);
    }

    @Override
    public Exception getException(String id) {
        Exception result = null;
        List el = (List)this.allExceptions.get(id);
        if (el != null && el.size() > 0) {
            result = (Exception)el.get(0);
        }
        return result;
    }

    @Override
    public Exception[] getExceptionArray(String id) {
        Exception[] result = new Exception[]{};
        List el = (List)this.allExceptions.get(id);
        if (el != null) {
            result = el.toArray(result);
        }
        return result;
    }

    public Iterator getExceptionIterator(String id) {
        ArrayList el = (ArrayList)this.allExceptions.get(id);
        if (el == null) {
            el = new ArrayList();
        }
        return el.iterator();
    }

    public Iterator getErrorMessageIterator() {
        return this.chronologicalErrorMessages.iterator();
    }

    public Iterator getBadParameterIDIterator() {
        return this.allExceptions.keySet().iterator();
    }

    public boolean success() {
        return this.allExceptions.size() == 0;
    }

    void registerQualifiedSwitch(String qsid, boolean present) {
        this.qualifiedSwitches.put(qsid, new Boolean(present));
    }
}

