/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.maf;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.Globals;
import org.broad.igv.feature.genome.ChromosomeNameComparator;
import org.broad.igv.tools.sort.SAMSorter;
import org.broad.igv.util.ParsingUtils;

public class MAFtoSAM {
    public static final int READ_PAIRED_FLAG = 1;
    public static final int PROPER_PAIR_FLAG = 2;
    public static final int READ_UNMAPPED_FLAG = 4;
    public static final int MATE_UNMAPPED_FLAG = 8;
    public static final int READ_STRAND_FLAG = 16;
    public static final int MATE_STRAND_FLAG = 32;
    public static final int FIRST_OF_PAIR_FLAG = 64;
    public static final int SECOND_OF_PAIR_FLAG = 128;
    public static final int NOT_PRIMARY_ALIGNMENT_FLAG = 256;
    public static final int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    public static final int DUPLICATE_READ_FLAG = 1024;
    public static final int SUPPLEMENTARY_FLAG = 2048;

    public static void main(String[] args) throws IOException {
        String inputPath = args[0];
        Object outputPath = args.length > 1 ? args[1] : args[0] + ".sam";
        MAFtoSAM.convert(inputPath, (String)outputPath, false);
    }

    public static void convert(String path, String outputPath, boolean noSATag) throws IOException {
        String line;
        File unsortedOutput = new File(outputPath + ".unsorted");
        File outputFile = new File(outputPath);
        BufferedReader reader = ParsingUtils.openBufferedReader(path);
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(unsortedOutput)));
        LinkedHashMap<String, Integer> sequenceDictionary = new LinkedHashMap<String, Integer>();
        while ((line = reader.readLine()) != null) {
            if (!line.startsWith("a")) continue;
            MAFtoSAM.parseBlock(reader, out, sequenceDictionary);
        }
        out.flush();
        out.close();
        reader.close();
        MAFtoSAM.addHeaderAndSort(unsortedOutput, outputFile, sequenceDictionary);
        unsortedOutput.deleteOnExit();
    }

    private static void parseBlock(BufferedReader reader, PrintWriter out, Map<String, Integer> sequenceDictionary) throws IOException {
        String line;
        SequenceLine referenceLine = null;
        byte[] refBytes = null;
        String chr = null;
        float score = -1.0f;
        while ((line = reader.readLine()) != null) {
            String[] srcTokens;
            if (line.trim().length() == 0) {
                return;
            }
            if (line.startsWith("a")) {
                String[] tokens;
                score = -1.0f;
                for (String token : tokens = Globals.whitespacePattern.split(line)) {
                    if (!token.startsWith("score=")) continue;
                    try {
                        score = Float.parseFloat(token.substring(6));
                    }
                    catch (NumberFormatException e) {
                        System.err.println("Could not parse score: " + token);
                    }
                }
            }
            if (!line.startsWith("s")) continue;
            if (null == referenceLine) {
                referenceLine = MAFtoSAM.parseSequenceLine(line);
                refBytes = referenceLine.text.getBytes();
                if (referenceLine.src.contains(".")) {
                    srcTokens = ParsingUtils.PERIOD_PATTERN.split(referenceLine.src, 2);
                    chr = srcTokens[1];
                } else {
                    chr = referenceLine.src;
                }
                sequenceDictionary.put(chr, referenceLine.srcSize);
                continue;
            }
            SequenceLine queryLine = MAFtoSAM.parseSequenceLine(line);
            srcTokens = ParsingUtils.PERIOD_PATTERN.split(queryLine.src, 2);
            String species = srcTokens[0];
            int flags = queryLine.strand == '+' ? 0 : 16;
            byte[] queryBytes = queryLine.text.getBytes();
            if (queryBytes.length != refBytes.length) {
                throw new RuntimeException("Query and ref sequence unequal length");
            }
            Object cigarString = "";
            int nm = 0;
            boolean indel = false;
            for (int i = 0; i < queryBytes.length; ++i) {
                byte q = queryBytes[i];
                byte ref = refBytes[i];
                if (q == 45) {
                    if (ref == 45) continue;
                    cigarString = (String)cigarString + "D";
                    if (indel) continue;
                    indel = true;
                    ++nm;
                    continue;
                }
                if (ref == 45) {
                    cigarString = (String)cigarString + "I";
                    if (indel) continue;
                    indel = true;
                    ++nm;
                    continue;
                }
                indel = false;
                cigarString = (String)cigarString + "M";
                if (queryBytes[i] == refBytes[i]) continue;
                ++nm;
            }
            cigarString = MAFtoSAM.collapseCigar((String)cigarString);
            String readName = queryLine.src;
            String barcode = null;
            if (readName.contains("Barcode")) {
                int bcIdx = readName.indexOf("Barcode") + 8;
                int endIdx = readName.indexOf(58, bcIdx);
                barcode = readName.substring(bcIdx, endIdx);
            }
            int start = referenceLine.start + 1;
            int mapq = 30;
            String rnext = "*";
            int pnext = 0;
            int tlen = 0;
            String seq = MAFtoSAM.collapseSequence(queryLine.text);
            String qual = "*";
            out.print(readName + "\t" + flags + "\t" + chr + "\t" + start + "\t" + mapq + "\t" + (String)cigarString + "\t" + rnext + "\t" + pnext + "\t" + tlen + "\t" + seq + "\t" + qual + "\tNM:i:" + nm + "\tRG:Z:" + species);
            if (barcode != null) {
                out.print("\tBC:Z:" + barcode);
            }
            if (score > 0.0f) {
                out.print("\tsc:f:" + String.valueOf(score));
            }
            out.println();
        }
    }

    private static void addHeaderAndSort(File inputFile, File outputFile, Map<String, Integer> sequenceDictionary) throws IOException {
        String line;
        String sortedOutput = inputFile.getAbsolutePath() + ".sam";
        SAMSorter sorter = new SAMSorter(inputFile, new File(sortedOutput));
        sorter.run();
        BufferedReader reader = new BufferedReader(new FileReader(sortedOutput));
        PrintWriter out = new PrintWriter(new BufferedWriter(new FileWriter(outputFile)));
        MAFtoSAM.outputHeader(sequenceDictionary, out);
        while ((line = reader.readLine()) != null) {
            out.println(line);
        }
        out.flush();
        out.close();
    }

    private static void outputHeader(Map<String, Integer> sequenceDictionary, PrintWriter out) {
        ArrayList<String> chrNames = new ArrayList<String>(sequenceDictionary.keySet());
        Collections.sort(chrNames, ChromosomeNameComparator.get());
        out.println("@HD\tVN:1.5");
        for (String chr : chrNames) {
            out.println("@SQ\tSN:" + chr + "\tLN:" + sequenceDictionary.get(chr));
        }
        out.println("@PG\tPN:MAFtoSAM\tID:MAFtoSAM");
    }

    private static String collapseCigar(String cigarString) {
        if (cigarString.length() == 0) {
            return "";
        }
        Object collapsedCigar = "";
        char lastOperator = cigarString.charAt(0);
        int counter = 1;
        for (int i = 1; i < cigarString.length(); ++i) {
            if (cigarString.charAt(i) == lastOperator) {
                ++counter;
                continue;
            }
            collapsedCigar = (String)collapsedCigar + counter + lastOperator;
            lastOperator = cigarString.charAt(i);
            counter = 1;
        }
        collapsedCigar = (String)collapsedCigar + counter + lastOperator;
        return collapsedCigar;
    }

    private static String collapseSequence(String text) {
        return text.replaceAll("-", "");
    }

    private static SequenceLine parseSequenceLine(String line) throws IOException {
        String[] tokens = Globals.whitespacePattern.split(line);
        SequenceLine sl = new SequenceLine();
        sl.src = tokens[1];
        sl.start = Integer.parseInt(tokens[2]);
        sl.size = Integer.parseInt(tokens[3]);
        sl.strand = tokens[4].charAt(0);
        sl.srcSize = Integer.parseInt(tokens[5]);
        sl.text = tokens[6];
        return sl;
    }

    static class SequenceLine {
        String src;
        int start;
        int size;
        char strand;
        int srcSize;
        String text;

        SequenceLine() {
        }
    }
}

