/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.google;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import java.awt.Desktop;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.prefs.Preferences;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.batch.CommandListener;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.google.GoogleUtils;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.util.AmazonUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.JWTParser;
import software.amazon.awssdk.services.sts.model.Credentials;

public class OAuthProvider {
    private static Logger log = Logger.getLogger(OAuthProvider.class);
    private String authProvider = "";
    private String appIdURI = null;
    public static String findString = null;
    public static String replaceString = null;
    private static final String REFRESH_TOKEN_KEY = "oauth_refresh_token";
    private String state = UUID.randomUUID().toString();
    private String redirectURI = "http%3A%2F%2Flocalhost%3A60151%2FoauthCallback";
    private String oobURI = "urn%3Aietf%3Awg%3Aoauth%3A2.0%3Aoob";
    private String clientId;
    private String clientSecret;
    private String authURI;
    private String tokenURI;
    private String authorizationCode;
    private String accessToken;
    private String refreshToken;
    private long expirationTime;
    private String scope;
    private String currentUserName;
    private String currentUserID;
    private String currentUserEmail;
    private JsonObject response;
    private JsonObject config;

    public OAuthProvider(JsonObject obj) throws IOException {
        this.config = obj;
        try {
            this.clientId = obj.get("client_id").getAsString();
            this.authURI = obj.has("auth_uri") ? obj.get("auth_uri").getAsString() : obj.get("authorization_endpoint").getAsString();
            this.tokenURI = obj.has("token_uri") ? obj.get("token_uri").getAsString() : obj.get("token_endpoint").getAsString();
        }
        catch (Exception e) {
            log.error((Object)e);
            throw new IOException("oauthConfig is missing crucial attributes such as: client_id, authorization_endpoint/auth_uri or token_endpoint/token_uri");
        }
        this.clientSecret = obj.has("client_secret") ? obj.get("client_secret").getAsString() : null;
        this.setAuthProvider(obj.has("auth_provider") ? obj.get("auth_provider").getAsString() : this.authProvider);
        String string = this.appIdURI = obj.has("app_id_uri") ? obj.get("app_id_uri").getAsString() : null;
        if (obj.has("scope")) {
            this.scope = obj.get("scope").getAsString();
        }
        if (this.authURI.contains("google")) {
            if (this.scope == null) {
                String gsScope = "https://www.googleapis.com/auth/devstorage.read_only";
                String driveScope = "https://www.googleapis.com/auth/drive.readonly";
                String emailScope = "https://www.googleapis.com/auth/userinfo.email";
                this.scope = gsScope + "%20" + emailScope;
            }
            if (this.authProvider == null) {
                this.authProvider = "Google";
            }
        }
    }

    public void openAuthorizationPage() throws IOException, URISyntaxException {
        String ac;
        String url;
        Desktop desktop = Desktop.getDesktop();
        String redirect = this.oobURI;
        if (CommandListener.isListening()) {
            redirect = this.redirectURI;
        }
        if (this.appIdURI == null) {
            log.debug((Object)"appIdURI is null, skipping resource setting");
            url = this.authURI + "?scope=" + this.scope + "&state=" + this.state + "&redirect_uri=" + redirect + "&response_type=code&client_id=" + this.clientId;
        } else {
            log.debug((Object)"appIdURI is not null, setting resource= as part of the authURI");
            url = this.authURI + "?scope=" + this.scope + "&state=" + this.state + "&redirect_uri=" + redirect + "&response_type=code&resource=" + this.appIdURI + "&client_id=" + this.clientId;
        }
        log.debug((Object)("URL for the auth page is: " + url));
        if (desktop.isSupported(Desktop.Action.BROWSE)) {
            desktop.browse(new URI(url));
        } else {
            MessageUtils.showMessage("Copy this authorization URL into your web browser: " + url);
        }
        if (!CommandListener.isListening() && (ac = MessageUtils.showInputDialog("Please paste authorization code here:")) != null) {
            this.setAuthorizationCode(ac, this.oobURI);
        }
    }

    public void setAuthorizationCode(String ac) throws IOException {
        this.setAuthorizationCode(ac, this.redirectURI);
    }

    public void setAuthorizationCode(String ac, String redirect) throws IOException {
        this.authorizationCode = ac;
        log.debug((Object)("oauth code parameter: " + ac));
        log.debug((Object)("url-encoded redirect_uri: " + redirect));
        this.fetchTokens(redirect);
    }

    public void setAccessToken(String accessToken) {
        this.accessToken = accessToken;
    }

    private void fetchTokens(String redirect) throws IOException {
        URL url = HttpUtils.createURL(this.tokenURI);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("code", this.authorizationCode);
        params.put("client_id", this.clientId);
        if (this.clientSecret != null) {
            params.put("client_secret", this.clientSecret);
        }
        new URLDecoder();
        params.put("redirect_uri", URLDecoder.decode(this.redirectURI, "utf-8"));
        params.put("grant_type", "authorization_code");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        try {
            String res = HttpUtils.getInstance().doPost(url, params);
            JsonParser parser = new JsonParser();
            this.setResponse(parser.parse(res).getAsJsonObject());
            this.accessToken = this.response.get("access_token").getAsString();
            this.refreshToken = this.response.get("refresh_token").getAsString();
            String idToken = this.response.get("id_token").getAsString();
            log.debug((Object)("Oauth2 refresh token: " + this.refreshToken));
            log.debug((Object)("Oauth2 token_id: " + idToken));
            log.debug((Object)("Oauth2 access token: " + this.accessToken));
            log.debug((Object)("Oauth2 state: " + this.state));
            this.refreshToken = this.response.get("refresh_token").getAsString();
            this.expirationTime = System.currentTimeMillis() + (long)(this.response.get("expires_in").getAsInt() * 1000);
            JsonObject payload = JWTParser.getPayload(this.response.get("id_token").getAsString());
            this.fetchUserProfile(payload);
            if (this.authProvider.equals("Amazon")) {
                Credentials aws_credentials = AmazonUtils.GetCognitoAWSCredentials();
                AmazonUtils.updateS3Client(aws_credentials);
            }
            if (this.isLoggedIn()) {
                IGVEventBus.getInstance().post(new AuthStateEvent(true, this.authProvider, this.getCurrentUserName()));
            }
        }
        catch (Exception e) {
            log.error((Object)e);
            e.printStackTrace();
        }
    }

    private void refreshAccessToken() throws IOException {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("refresh_token", this.refreshToken);
        params.put("client_id", this.clientId);
        params.put("client_secret", this.clientSecret);
        params.put("grant_type", "refresh_token");
        if (this.appIdURI != null) {
            params.put("resource", this.appIdURI);
        }
        URL url = HttpUtils.createURL(this.tokenURI);
        String response = HttpUtils.getInstance().doPost(url, params);
        JsonParser parser = new JsonParser();
        this.setResponse(parser.parse(response).getAsJsonObject());
        JsonObject obj = this.getResponse();
        JsonPrimitive atprim = obj.getAsJsonPrimitive("access_token");
        if (atprim != null) {
            this.accessToken = obj.getAsJsonPrimitive("access_token").getAsString();
            this.expirationTime = System.currentTimeMillis() + (long)(obj.getAsJsonPrimitive("expires_in").getAsInt() * 1000);
        } else {
            this.reauthorize();
        }
    }

    private void reauthorize() throws IOException {
        this.logout();
        try {
            this.openAuthorizationPage();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
    }

    public JsonObject fetchUserProfile(JsonObject jwt_payload) throws IOException {
        try {
            String string = this.currentUserName = jwt_payload.has("name") ? jwt_payload.get("name").getAsString() : null;
            if (this.currentUserName == null && jwt_payload.has("cognito:username")) {
                this.currentUserName = jwt_payload.get("cognito:username").getAsString();
            }
            this.currentUserEmail = jwt_payload.has("email") ? jwt_payload.get("email").getAsString() : null;
            this.currentUserID = jwt_payload.has("id") ? jwt_payload.get("id").getAsString() : null;
            return jwt_payload;
        }
        catch (Throwable exception) {
            log.error((Object)exception);
            return null;
        }
    }

    public String getAccessToken() {
        if (this.accessToken == null || System.currentTimeMillis() > this.expirationTime - (long)Globals.TOKEN_EXPIRE_GRACE_TIME) {
            log.debug((Object)"Refreshing access token!");
            if (this.refreshToken != null) {
                try {
                    this.refreshAccessToken();
                }
                catch (IOException e) {
                    log.error((Object)"Error fetching access token", (Throwable)e);
                }
            }
        }
        return this.accessToken;
    }

    public Duration getExpirationTime() {
        Duration expiration = Duration.ofMillis(this.expirationTime - System.currentTimeMillis());
        log.debug((Object)("Current expiration time of credentials (and presigned urls is): " + expiration.toSeconds() + " seconds and expirationTime in class is: " + this.expirationTime));
        return expiration;
    }

    public JsonObject getConfig() {
        return this.config;
    }

    public boolean isLoggedIn() {
        return this.getAccessToken() != null;
    }

    public String getCurrentUserName() {
        return this.currentUserName;
    }

    public void logout() {
        this.accessToken = null;
        this.refreshToken = null;
        this.expirationTime = -1L;
        this.currentUserName = null;
        this.removeRefreshToken();
    }

    private void removeRefreshToken() {
        try {
            Preferences.userRoot().remove(REFRESH_TOKEN_KEY);
        }
        catch (Exception e) {
            log.error((Object)"Error removing oauth refresh token", (Throwable)e);
        }
    }

    public void updateSaveOption(boolean aBoolean) {
        if (aBoolean) {
            if (this.refreshToken != null) {
                // empty if block
            }
        } else {
            this.removeRefreshToken();
        }
    }

    public void doSecureLogin() {
        if (!this.isLoggedIn()) {
            try {
                this.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error((Object)"Error fetching oAuth tokens", (Throwable)ex);
            }
        }
        int i = 0;
        while (!this.isLoggedIn() && i < 600) {
            ++i;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e1) {
                e1.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Set<String> findUrlsInSessionFile(String sessionPath) {
        BufferedReader br = null;
        HashSet<String> urlSet = new HashSet<String>();
        try {
            String line;
            br = new BufferedReader(new FileReader(new File(sessionPath)));
            while ((line = br.readLine()) != null) {
                int start = line.indexOf("http");
                if (start == -1) continue;
                int mid = line.indexOf("://", start);
                int end = line.indexOf("/", mid + 3);
                String url = line.substring(start, end);
                urlSet.add(url);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return urlSet;
    }

    public void checkServerLogin(String sessionPath) {
        Set<String> urlSet = OAuthProvider.findUrlsInSessionFile(sessionPath);
        if (urlSet.size() > 0) {
            for (String url : urlSet) {
                if (!GoogleUtils.isGoogleCloud(url)) continue;
                this.doSecureLogin();
                return;
            }
        }
    }

    public JsonObject getResponse() {
        return this.response;
    }

    public void setResponse(JsonObject res) {
        this.response = res;
    }

    public String getAuthProvider() {
        return this.authProvider;
    }

    public void setAuthProvider(String authProvider) {
        this.authProvider = authProvider;
    }

    public class AuthStateEvent {
        boolean authenticated;
        String authProvider;
        String userName;
        String email;

        public AuthStateEvent(boolean authenticated, String authProvider, String userName) {
            this.authenticated = authenticated;
            this.authProvider = authProvider;
            this.userName = userName;
        }

        public boolean isAuthenticated() {
            return this.authenticated;
        }

        public String getAuthProvider() {
            return this.authProvider;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getEmail() {
            return OAuthProvider.this.currentUserEmail;
        }
    }
}

