/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans;

import htsjdk.samtools.cram.compression.rans.Decoding;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class D14 {
    D14() {
    }

    static void uncompress(ByteBuffer in, ByteBuffer out_buf, Decoding.AriDecoder[] D, Decoding.RansDecSymbol[][] syms) {
        int out_sz = out_buf.remaining();
        in.order(ByteOrder.LITTLE_ENDIAN);
        int rans0 = in.getInt();
        int rans1 = in.getInt();
        int rans2 = in.getInt();
        int rans7 = in.getInt();
        int isz4 = out_sz >> 2;
        int i0 = 0;
        int i1 = isz4;
        int i2 = 2 * isz4;
        int i7 = 3 * isz4;
        int l0 = 0;
        int l1 = 0;
        int l2 = 0;
        int l7 = 0;
        while (i0 < isz4) {
            int c0 = 0xFF & D[l0].R[Decoding.RansDecGet(rans0, 12)];
            int c1 = 0xFF & D[l1].R[Decoding.RansDecGet(rans1, 12)];
            int c2 = 0xFF & D[l2].R[Decoding.RansDecGet(rans2, 12)];
            int c7 = 0xFF & D[l7].R[Decoding.RansDecGet(rans7, 12)];
            out_buf.put(i0, (byte)c0);
            out_buf.put(i1, (byte)c1);
            out_buf.put(i2, (byte)c2);
            out_buf.put(i7, (byte)c7);
            rans0 = Decoding.RansDecAdvanceSymbolStep(rans0, syms[l0][c0], 12);
            rans1 = Decoding.RansDecAdvanceSymbolStep(rans1, syms[l1][c1], 12);
            rans2 = Decoding.RansDecAdvanceSymbolStep(rans2, syms[l2][c2], 12);
            rans7 = Decoding.RansDecAdvanceSymbolStep(rans7, syms[l7][c7], 12);
            rans0 = Decoding.RansDecRenormalize(rans0, in);
            rans1 = Decoding.RansDecRenormalize(rans1, in);
            rans2 = Decoding.RansDecRenormalize(rans2, in);
            rans7 = Decoding.RansDecRenormalize(rans7, in);
            l0 = c0;
            l1 = c1;
            l2 = c2;
            l7 = c7;
            ++i0;
            ++i1;
            ++i2;
            ++i7;
        }
        while (i7 < out_sz) {
            int c7 = 0xFF & D[l7].R[Decoding.RansDecGet(rans7, 12)];
            out_buf.put(i7, (byte)c7);
            rans7 = Decoding.RansDecAdvanceSymbol(rans7, in, syms[l7][c7], 12);
            l7 = c7;
            ++i7;
        }
    }
}

