/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.track;

import htsjdk.tribble.Feature;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.event.IGVEventObserver;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.BarChartRenderer;
import org.broad.igv.renderer.ColorScaleFactory;
import org.broad.igv.renderer.ContinuousColorScale;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.GraphicUtils;
import org.broad.igv.renderer.HeatmapRenderer;
import org.broad.igv.renderer.PointsRenderer;
import org.broad.igv.renderer.Renderer;
import org.broad.igv.renderer.XYPlotRenderer;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.track.TrackType;
import org.broad.igv.track.WindowFunction;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.TooltipTextFrame;
import org.broad.igv.ui.UIConstants;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.MouseableRegion;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public abstract class AbstractTrack
implements Track {
    public static final Color DEFAULT_COLOR = Color.blue.darker();
    public static final Track.DisplayMode DEFAULT_DISPLAY_MODE = Track.DisplayMode.COLLAPSED;
    public static final int DEFAULT_HEIGHT = -1;
    public static final int VISIBILITY_WINDOW = -1;
    private static Logger log = Logger.getLogger(AbstractTrack.class);
    public static final Set<Class> knownUnknownTrackClasses = new HashSet<Class>();
    public static final Class defaultTrackClass = AbstractTrack.class;
    private static Class defaultRendererClass = BarChartRenderer.class;
    private static Map<TrackType, Class> defaultRendererMap = new HashMap<TrackType, Class>();
    protected String id;
    private String attributeKey;
    private String name;
    private String url;
    private boolean itemRGB = true;
    private boolean useScore;
    private float viewLimitMin = Float.NaN;
    private float viewLimitMax = Float.NaN;
    protected int fontSize = PreferencesManager.getPreferences().getAsInt("DEFAULT_FONT_SIZE");
    private boolean showDataRange = true;
    protected String sampleId;
    private ResourceLocator resourceLocator;
    private int top;
    protected int minimumHeight = -1;
    protected int maximumHeight = 1000;
    private TrackType trackType = TrackType.OTHER;
    private boolean selected = false;
    private boolean visible = true;
    private boolean sortable = true;
    boolean overlaid;
    boolean drawYLine = false;
    float yLine = 0.0f;
    private Map<String, String> attributes = new HashMap<String, String>();
    private ContinuousColorScale colorScale;
    protected boolean autoScale;
    String autoscaleGroup;
    protected Color posColor;
    protected Color altColor = this.posColor = DEFAULT_COLOR;
    protected int visibilityWindow = -1;
    private Track.DisplayMode displayMode = DEFAULT_DISPLAY_MODE;
    protected Integer height = -1;
    protected DataRange dataRange;

    public AbstractTrack() {
    }

    public AbstractTrack(ResourceLocator dataResourceLocator, String id, String name) {
        this.resourceLocator = dataResourceLocator;
        this.id = id;
        this.attributeKey = this.name = name;
        this.init();
    }

    public AbstractTrack(ResourceLocator locator) {
        this(locator, locator != null ? locator.getPath() : null, locator != null ? locator.getTrackName() : null);
    }

    private void init() {
        this.showDataRange = PreferencesManager.getPreferences().getAsBoolean("CHART.SHOW_DATA_RANGE");
        if (PreferencesManager.getPreferences().getAsBoolean("EXPAND_FEATURE_TRACKS")) {
            this.displayMode = Track.DisplayMode.EXPANDED;
        }
    }

    @Override
    public void setRendererClass(Class rc) {
    }

    public String getUrl() {
        return this.url;
    }

    @Override
    public void setUrl(String url) {
        this.url = url;
    }

    public void setUseScore(boolean useScore) {
        this.useScore = useScore;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setName(String name) {
        this.name = name;
        this.setAttributeValue("NAME", name);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDisplayName() {
        String name;
        String sampleKey = IGV.getInstance().getSession().getTrackAttributeName();
        if (sampleKey != null && sampleKey.trim().length() > 0 && (name = this.getAttributeValue(sampleKey.trim())) != null) {
            return name;
        }
        return this.getName();
    }

    @Override
    public void setSampleId(String sampleId) {
        this.sampleId = sampleId;
    }

    @Override
    public boolean isFilterable() {
        return true;
    }

    @Override
    public void renderName(Graphics2D g2D, Rectangle trackRectangle, Rectangle visibleRectangle) {
        Rectangle rect = this.getDisplayableRect(trackRectangle, visibleRectangle);
        String trackName = this.getDisplayName();
        if (trackName != null && rect.getHeight() > 3.0) {
            int gap = Math.min(4, rect.height / 3);
            int fs = Math.min(this.fontSize, rect.height - gap);
            Font font = FontManager.getFont(fs);
            g2D.setFont(font);
            GraphicUtils.drawWrappedText(trackName, rect, g2D, false);
        }
    }

    @Override
    public void renderAttributes(Graphics2D graphics, Rectangle trackRectangle, Rectangle visibleRect, List<String> names, List<MouseableRegion> mouseRegions) {
        int x = trackRectangle.x;
        for (String name : names) {
            String key = name.toUpperCase();
            String attributeValue = this.getAttributeValue(key);
            if (attributeValue != null) {
                Rectangle rect = new Rectangle(x, trackRectangle.y, 10, trackRectangle.height);
                graphics.setColor(AttributeManager.getInstance().getColor(key, attributeValue));
                graphics.fill(rect);
                mouseRegions.add(new MouseableRegion(rect, key, attributeValue));
            }
            x += 11;
        }
    }

    private Rectangle getDisplayableRect(Rectangle trackRectangle, Rectangle visibleRect) {
        Rectangle rect = null;
        if (visibleRect != null) {
            Rectangle intersectedRect = trackRectangle.intersection(visibleRect);
            rect = intersectedRect.height > 15 ? intersectedRect : new Rectangle(trackRectangle);
        }
        return rect;
    }

    @Override
    public void overlay(RenderContext context, Rectangle rect) {
    }

    @Override
    public Color getColor() {
        return this.posColor;
    }

    @Override
    public Color getAltColor() {
        return this.altColor;
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return this.resourceLocator;
    }

    @Override
    public Collection<ResourceLocator> getResourceLocators() {
        return Arrays.asList(this.getResourceLocator());
    }

    @Override
    public void setAttributeValue(String name, String value) {
        String key = name.toUpperCase();
        if (key.equals("AUTOSCALE GROUP")) {
            this.autoscaleGroup = value;
        } else {
            this.attributes.put(key, value);
        }
        AttributeManager.getInstance().addAttribute(this.getSample(), name, value);
    }

    @Override
    public void removeAttribute(String name) {
        String key = name.toUpperCase();
        if (key.equals("AUTOSCALE GROUP")) {
            this.autoscaleGroup = null;
        } else {
            this.attributes.remove(key);
        }
        AttributeManager.getInstance().removeAttribute(this.getSample(), name);
    }

    @Override
    public String getAttributeValue(String attributeName) {
        String value;
        String key = attributeName.toUpperCase();
        if (key.equals("AUTOSCALE GROUP")) {
            value = this.autoscaleGroup;
            if (value == null) {
                this.autoscaleGroup = value = this.getFromAttributeManager(key);
            }
        } else {
            value = this.attributes.get(key);
            if (value == null) {
                value = this.getFromAttributeManager(key);
            }
        }
        return value;
    }

    private String getFromAttributeManager(String key) {
        AttributeManager attributeManager = AttributeManager.getInstance();
        String value = null;
        if (value == null && this.getSample() != null) {
            value = attributeManager.getAttribute(this.getSample(), key);
        }
        if (value == null) {
            value = attributeManager.getAttribute(this.attributeKey, key);
        }
        if (value == null && this.getResourceLocator() != null && this.getResourceLocator().getPath() != null) {
            value = attributeManager.getAttribute(this.getResourceLocator().getPath(), key);
        }
        return value;
    }

    @Override
    public String getSample() {
        if (this.sampleId != null) {
            return this.sampleId;
        }
        this.sampleId = AttributeManager.getInstance().getSampleFor(this.getName());
        return this.sampleId != null ? this.sampleId : this.getName();
    }

    private int getDefaultHeight() {
        if (XYPlotRenderer.class.isAssignableFrom(this.getDefaultRendererClass())) {
            return PreferencesManager.getPreferences().getAsInt("IGV.chart.track.height");
        }
        return PreferencesManager.getPreferences().getAsInt("IGV.track.height");
    }

    public int getDefaultMinimumHeight() {
        Renderer r = this.getRenderer();
        if (r != null && HeatmapRenderer.class.isAssignableFrom(r.getClass())) {
            return 1;
        }
        return 10;
    }

    public void setMinimumHeight(int minimumHeight) {
        this.minimumHeight = minimumHeight;
    }

    public void setMaximumHeight(int maximumHeight) {
        this.maximumHeight = maximumHeight;
    }

    @Override
    public int getMinimumHeight() {
        return this.minimumHeight < 0 ? this.getDefaultMinimumHeight() : this.minimumHeight;
    }

    public int getMaximumHeight() {
        return this.maximumHeight;
    }

    public void setTrackType(TrackType type) {
        this.trackType = type;
    }

    @Override
    public TrackType getTrackType() {
        return this.trackType;
    }

    @Override
    public boolean isVisible() {
        boolean displayOverlays;
        if (this.visible && this.getTrackType() == TrackType.MUTATION && (displayOverlays = IGV.getInstance().getSession().getOverlayMutationTracks())) {
            if (this.overlaid) {
                return false;
            }
            return PreferencesManager.getPreferences().getAsBoolean("SHOW_ORPHANED_MUTATIONS");
        }
        return this.visible;
    }

    @Override
    public void setColor(Color color) {
        this.posColor = color;
    }

    @Override
    public void setAltColor(Color color) {
        this.altColor = color;
    }

    @Override
    public void setVisible(boolean isVisible) {
        this.visible = isVisible;
    }

    @Override
    public void setOverlayed(boolean bool) {
        this.overlaid = bool;
    }

    @Override
    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    @Override
    public boolean isSelected() {
        return this.selected;
    }

    @Override
    public void setHeight(int height) {
        this.setHeight(height, false);
    }

    @Override
    public void setHeight(int preferredHeight, boolean force) {
        if (this.height < this.getHeight() && this.getDisplayMode() == Track.DisplayMode.EXPANDED && this.getTrackType() != TrackType.GENE) {
            this.setDisplayMode(Track.DisplayMode.SQUISHED);
        }
        this.height = force ? Integer.valueOf(preferredHeight) : Integer.valueOf(Math.min(Math.max(this.getMinimumHeight(), preferredHeight), this.getMaximumHeight()));
    }

    @Override
    public int getHeight() {
        return this.height < 0 ? this.getDefaultHeight() : this.height.intValue();
    }

    @Override
    public boolean hasDataRange() {
        return this.dataRange != null;
    }

    @Override
    public DataRange getDataRange() {
        if (this.dataRange == null) {
            float min = (float)(this.colorScale == null ? 0.0 : this.colorScale.getMinimum());
            float max = (float)(this.colorScale == null ? 10.0 : this.colorScale.getMaximum());
            float baseline = (float)(this.colorScale == null ? 0.0 : (this.colorScale.getNegStart() + this.colorScale.getPosStart()) / 2.0);
            this.setDataRange(new DataRange(min, baseline, max));
        }
        return this.dataRange;
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        this.dataRange = axisDefinition;
    }

    protected Class getDefaultRendererClass() {
        Class def = defaultRendererMap.get((Object)this.getTrackType());
        return def == null ? defaultRendererClass : def;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return new ArrayList<WindowFunction>();
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        if (IGV.getInstance().isShowDetailsOnClick()) {
            return this.openTooltipWindow(te);
        }
        return false;
    }

    protected boolean openTooltipWindow(TrackClickEvent e) {
        ReferenceFrame frame = e.getFrame();
        MouseEvent me = e.getMouseEvent();
        String popupText = this.getValueStringAt(frame.getChrName(), e.getChromosomePosition(), e.getMouseEvent().getX(), e.getMouseEvent().getY(), frame);
        if (popupText != null) {
            final TooltipTextFrame tf = new TooltipTextFrame(this.getName(), popupText);
            Point p = me.getComponent().getLocationOnScreen();
            tf.setLocation(Math.max(0, p.x + me.getX() - 150), Math.max(0, p.y + me.getY() - 150));
            UIUtilities.invokeOnEventThread(new Runnable(){

                @Override
                public void run() {
                    tf.setVisible(true);
                }
            });
            return true;
        }
        return false;
    }

    @Override
    public void handleNameClick(MouseEvent e) {
    }

    @Override
    public void setAutoScale(boolean autoScale) {
        this.autoScale = autoScale;
    }

    @Override
    public void setProperties(TrackProperties properties) {
        Map<String, String> attributes;
        this.itemRGB = properties.isItemRGB();
        this.useScore = properties.isUseScore();
        this.viewLimitMin = properties.getMinValue();
        this.viewLimitMax = properties.getMaxValue();
        this.yLine = properties.getyLine();
        this.drawYLine = properties.isDrawYLine();
        this.sortable = properties.isSortable();
        if (!Float.isNaN(this.viewLimitMin) && !Float.isNaN(this.viewLimitMax)) {
            this.setAutoScale(false);
        } else {
            this.setAutoScale(properties.isAutoScale());
        }
        if (!properties.isAutoScale()) {
            float min = properties.getMinValue();
            float max = properties.getMaxValue();
            float mid = properties.getMidValue();
            if (Float.isNaN(mid)) {
                mid = min >= 0.0f ? Math.max(min, 0.0f) : Math.min(max, 0.0f);
            }
            DataRange dr = new DataRange(min, mid, max);
            this.setDataRange(dr);
            if (properties.isLogScale()) {
                dr.setType(DataRange.Type.LOG);
            }
            Color maxColor = properties.getColor();
            Color minColor = properties.getAltColor();
            if (maxColor != null && minColor != null) {
                float tmp = properties.getNeutralFromValue();
                float neutralFrom = Float.isNaN(tmp) ? mid : tmp;
                tmp = properties.getNeutralToValue();
                float neutralTo = Float.isNaN(tmp) ? mid : tmp;
                Color midColor = properties.getMidColor();
                if (midColor == null) {
                    midColor = Color.white;
                }
                this.colorScale = new ContinuousColorScale(neutralFrom, min, neutralTo, max, minColor, midColor, maxColor);
            }
        }
        if (properties.getDisplayMode() != null) {
            this.setDisplayMode(properties.getDisplayMode());
        }
        if (properties.getName() != null) {
            this.name = properties.getName();
        }
        if (properties.getColor() != null) {
            this.setColor(properties.getColor());
        }
        if (properties.getAltColor() != null) {
            this.setAltColor(properties.getAltColor());
        }
        if (properties.getMidColor() != null) {
            // empty if block
        }
        if (properties.getHeight() > 0) {
            this.setHeight(properties.getHeight());
        }
        if (properties.getMinHeight() > 0) {
            this.setMinimumHeight(properties.getMinHeight());
        }
        if (properties.getRendererClass() != null) {
            this.setRendererClass(properties.getRendererClass());
            if (properties.getRendererClass() == PointsRenderer.class) {
                this.setWindowFunction(WindowFunction.none);
            }
        }
        if (properties.getWindowingFunction() != null) {
            this.setWindowFunction(properties.getWindowingFunction());
        }
        if (properties.getUrl() != null) {
            this.setUrl(properties.getUrl());
        }
        if ((attributes = properties.getAttributes()) != null) {
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                this.setAttributeValue(entry.getKey(), entry.getValue());
            }
        }
        this.autoScale = properties.getAutoScale();
    }

    @Override
    public int getY() {
        return this.top;
    }

    @Override
    public void setColorScale(ContinuousColorScale colorScale) {
        this.colorScale = colorScale;
    }

    @Override
    public void setY(int top) {
        this.top = top;
    }

    @Override
    public ContinuousColorScale getColorScale() {
        if (this.colorScale == null) {
            ContinuousColorScale defaultScale;
            if (IGV.hasInstance() && (defaultScale = IGV.getInstance().getSession().getColorScale(this.trackType)) != null) {
                this.colorScale = defaultScale;
                return defaultScale;
            }
            double min = this.dataRange == null ? 0.0 : (double)this.dataRange.getMinimum();
            double max = this.dataRange == null ? 10.0 : (double)this.dataRange.getMaximum();
            Color c = this.getColor();
            Color minColor = Color.white;
            if (min < 0.0) {
                minColor = this.altColor == null ? this.oppositeColor(minColor) : this.altColor;
                this.colorScale = new ContinuousColorScale(min, 0.0, max, minColor, Color.white, c);
            } else {
                this.colorScale = new ContinuousColorScale(min, max, minColor, c);
            }
            this.colorScale.setNoDataColor(UIConstants.NO_DATA_COLOR);
        }
        return this.colorScale;
    }

    private Color oppositeColor(Color c) {
        float[] rgb = new float[4];
        c.getRGBComponents(rgb);
        rgb[0] = Math.abs(rgb[0] - 255.0f);
        rgb[1] = Math.abs(rgb[1] - 255.0f);
        rgb[2] = Math.abs(rgb[2] - 255.0f);
        return Color.getHSBColor(rgb[0], rgb[1], rgb[2]);
    }

    @Override
    public boolean isItemRGB() {
        return this.itemRGB;
    }

    @Override
    public boolean isUseScore() {
        return this.useScore;
    }

    @Override
    public float getViewLimitMin() {
        return this.viewLimitMin;
    }

    @Override
    public float getViewLimitMax() {
        return this.viewLimitMax;
    }

    @Override
    public int getFontSize() {
        return this.fontSize;
    }

    @Override
    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    @Override
    public boolean isShowDataRange() {
        return this.showDataRange;
    }

    public void setShowDataRange(boolean showDataRange) {
        this.showDataRange = showDataRange;
    }

    @Override
    public Feature getFeatureAtMousePosition(TrackClickEvent e) {
        return null;
    }

    public static float getLogNormalizedValue(float value, double norm) {
        if (norm == 0.0) {
            return Float.NaN;
        }
        return (float)(Math.log((double)Math.max(Float.MIN_VALUE, value) / norm) / Globals.log2);
    }

    @Override
    public float logScaleData(float dataY) {
        if (!(this.getTrackType() != TrackType.COPY_NUMBER && this.getTrackType() != TrackType.ALLELE_SPECIFIC_COPY_NUMBER && this.getTrackType() != TrackType.CNV || this.isLogNormalized())) {
            double centerValue = this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER ? 1.0 : 2.0;
            dataY = AbstractTrack.getLogNormalizedValue(dataY, centerValue);
        }
        return dataY;
    }

    @Override
    public boolean isRegionScoreType(RegionScoreType type) {
        return this.getTrackType() == TrackType.GENE_EXPRESSION && type == RegionScoreType.EXPRESSION || (this.getTrackType() == TrackType.COPY_NUMBER || this.getTrackType() == TrackType.CNV || this.getTrackType() == TrackType.ALLELE_SPECIFIC_COPY_NUMBER) && (type == RegionScoreType.AMPLIFICATION || type == RegionScoreType.DELETION || type == RegionScoreType.FLUX) || type == RegionScoreType.MUTATION_COUNT || type == RegionScoreType.SCORE;
    }

    @Override
    public void setVisibilityWindow(int i) {
        this.visibilityWindow = i;
    }

    @Override
    public int getVisibilityWindow() {
        return this.visibilityWindow;
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        return null;
    }

    @Override
    public Track.DisplayMode getDisplayMode() {
        return this.displayMode;
    }

    @Override
    public void setDisplayMode(Track.DisplayMode mode) {
        this.displayMode = mode;
    }

    @Override
    public String getNameValueString(int y) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<html>" + this.getName());
        if (this.resourceLocator != null && this.resourceLocator.getPath() != null) {
            buffer.append("<br>" + this.resourceLocator.getPath());
        }
        return buffer.toString();
    }

    @Override
    public String getValueStringAt(String chr, double position, int mouseX, int mouseY, ReferenceFrame frame) {
        return null;
    }

    @Override
    public void setWindowFunction(WindowFunction type) {
    }

    @Override
    public WindowFunction getWindowFunction() {
        return null;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return this.getRegionScore(chr, start, end, zoom, type, frameName, null);
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName, List<Track> tracks) {
        return 0.0f;
    }

    public boolean isLogNormalized() {
        return true;
    }

    @Override
    public boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(boolean sortable) {
        this.sortable = sortable;
    }

    @Override
    public boolean isDrawYLine() {
        return this.drawYLine;
    }

    @Override
    public float getYLine() {
        return this.yLine;
    }

    @Override
    public void dispose() {
        if (this instanceof IGVEventObserver) {
            IGVEventBus.getInstance().unsubscribe((IGVEventObserver)((Object)this));
        }
    }

    protected void setRenderer(Renderer renderer) {
    }

    @Override
    public Renderer getRenderer() {
        return null;
    }

    @Override
    public boolean getAutoScale() {
        return this.autoScale;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        element.setAttribute("name", this.name);
        element.setAttribute("attributeKey", this.attributeKey);
        element.setAttribute("id", this.id);
        element.setAttribute("fontSize", String.valueOf(this.fontSize));
        element.setAttribute("visible", String.valueOf(this.visible));
        if (this.posColor != DEFAULT_COLOR) {
            element.setAttribute("color", ColorUtilities.colorToString(this.posColor));
        }
        if (this.altColor != DEFAULT_COLOR) {
            element.setAttribute("altColor", ColorUtilities.colorToString(this.altColor));
        }
        if (this.visibilityWindow != -1) {
            element.setAttribute("featureVisibilityWindow", String.valueOf(this.visibilityWindow));
        }
        if (this.displayMode != DEFAULT_DISPLAY_MODE) {
            element.setAttribute("displayMode", this.displayMode.toString());
        }
        if (this.height != -1) {
            element.setAttribute("height", this.height.toString());
        }
        if (this.colorScale != null) {
            element.setAttribute("colorScale", this.colorScale.asString());
        }
        if (this.height != -1) {
            element.setAttribute("height", String.valueOf(this.height));
        }
        if (!this.showDataRange) {
            element.setAttribute("showDataRange", Boolean.toString(this.showDataRange));
        }
        if (this.isNumeric()) {
            if (this.autoscaleGroup != null) {
                element.setAttribute("autoscaleGroup", this.autoscaleGroup);
            }
            element.setAttribute("autoScale", String.valueOf(this.autoScale));
            if (this.getWindowFunction() != null) {
                element.setAttribute("windowFunction", String.valueOf(this.getWindowFunction()));
            }
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        NodeList nodeList;
        Color c;
        this.name = element.getAttribute("name");
        this.id = element.getAttribute("id");
        this.attributeKey = element.hasAttribute("attributeKey") ? element.getAttribute("attributeKey") : this.name;
        if (element.hasAttribute("displayMode")) {
            try {
                this.displayMode = Track.DisplayMode.valueOf(element.getAttribute("displayMode"));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unrecognized displayMode: " + element.getAttribute("displayMode")));
                this.displayMode = Track.DisplayMode.COLLAPSED;
            }
        }
        if (element.hasAttribute("color")) {
            try {
                this.posColor = c = ColorUtilities.stringToColor(element.getAttribute("color"));
                this.altColor = c;
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized color: " + element.getAttribute("color")));
            }
        }
        if (element.hasAttribute("altColor")) {
            try {
                this.altColor = c = ColorUtilities.stringToColor(element.getAttribute("altColor"));
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized altColor: " + element.getAttribute("altColor")));
            }
        }
        if (element.hasAttribute("colorScale")) {
            try {
                this.colorScale = (ContinuousColorScale)ColorScaleFactory.getScaleFromString(element.getAttribute("colorScale"));
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized colorScale: " + element.getAttribute("colorScale")));
            }
        }
        if (element.hasAttribute("visible")) {
            try {
                this.setVisible(Boolean.parseBoolean(element.getAttribute("visible")));
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized visisbilty: " + element.getAttribute("visible")));
            }
        }
        if (element.hasAttribute("autoScale")) {
            try {
                this.autoScale = Boolean.valueOf(element.getAttribute("autoScale"));
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized autoScale: " + element.getAttribute("autoScale")));
            }
        }
        if (element.hasAttribute("autoscaleGroup")) {
            String autoscaleGroup = element.getAttribute("autoscaleGroup");
            this.setAttributeValue("AUTOSCALE GROUP", autoscaleGroup);
        }
        if (element.hasAttribute("showDataRange")) {
            try {
                this.showDataRange = Boolean.valueOf(element.getAttribute("showDataRange"));
            }
            catch (Exception e) {
                log.error((Object)("Unrecognized showDataRange: " + element.getAttribute("showDataRange")));
            }
        }
        if (element.hasAttribute("featureVisibilityWindow")) {
            try {
                this.visibilityWindow = Integer.parseInt(element.getAttribute("featureVisibilityWindow"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Unrecognized featureVisibilityWindow: " + element.getAttribute("featureVisibilityWindow")));
            }
        }
        if (element.hasAttribute("fontSize")) {
            try {
                this.fontSize = Integer.parseInt(element.getAttribute("fontSize"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Unrecognized fontSize: " + element.getAttribute("fontSize")));
            }
        }
        if (element.hasAttribute("height")) {
            try {
                this.height = Integer.parseInt(element.getAttribute("height"));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Unrecognized height: " + element.getAttribute("height")));
            }
        }
        if (element.hasAttribute("windowFunction")) {
            try {
                this.setWindowFunction(WindowFunction.valueOf(element.getAttribute("windowFunction")));
            }
            catch (IllegalArgumentException e) {
                log.error((Object)("Unknown windowFunction: " + element.getAttribute("windowFunction")), (Throwable)e);
            }
        }
        if (version <= 3 && element.hasAttribute("scale")) {
            String scale = element.getAttribute("scale");
            try {
                String[] axis = scale.split(",");
                float minimum = Float.parseFloat(axis[0]);
                float baseline = Float.parseFloat(axis[1]);
                float maximum = Float.parseFloat(axis[2]);
                this.setDataRange(new DataRange(minimum, baseline, maximum));
            }
            catch (NumberFormatException e) {
                log.error((Object)("Unrecognized dataRange: " + element.getAttribute("scale")));
            }
        }
        if ((nodeList = element.getElementsByTagName("DataRange")) != null && nodeList.getLength() > 0) {
            Element dataRangeElement = (Element)nodeList.item(0);
            try {
                this.dataRange = new DataRange(dataRangeElement, version);
            }
            catch (Exception e) {
                log.error((Object)"Unrecognized DataRange");
            }
        }
    }

    static {
        defaultRendererMap.put(TrackType.RNAI, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.CNV, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.ALLELE_SPECIFIC_COPY_NUMBER, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.GENE_EXPRESSION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.DNA_METHYLATION, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.LOH, HeatmapRenderer.class);
        defaultRendererMap.put(TrackType.OTHER, BarChartRenderer.class);
        defaultRendererMap.put(TrackType.CHIP_CHIP, HeatmapRenderer.class);
    }
}

