/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.ByteArrayLenEncoding;
import htsjdk.samtools.cram.encoding.CRAMEncoding;
import htsjdk.samtools.cram.encoding.core.BetaIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanByteEncoding;
import htsjdk.samtools.cram.encoding.core.CanonicalHuffmanIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.GammaIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.SubexponentialIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombIntegerEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombLongEncoding;
import htsjdk.samtools.cram.encoding.core.experimental.GolombRiceIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ByteArrayStopEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteArrayEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalByteEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalIntegerEncoding;
import htsjdk.samtools.cram.encoding.external.ExternalLongEncoding;
import htsjdk.samtools.cram.structure.DataSeriesType;
import htsjdk.samtools.cram.structure.EncodingDescriptor;
import htsjdk.samtools.cram.structure.EncodingID;

public class EncodingFactory {
    public static <T> CRAMEncoding<T> createCRAMEncoding(DataSeriesType valueType, EncodingDescriptor encodingDescriptor) {
        return EncodingFactory.createCRAMEncoding(valueType, encodingDescriptor.getEncodingID(), encodingDescriptor.getEncodingParameters());
    }

    public static <T> CRAMEncoding<T> createCRAMEncoding(DataSeriesType valueType, EncodingID encodingID, byte[] params) {
        switch (valueType) {
            case BYTE: {
                switch (encodingID) {
                    case EXTERNAL: {
                        return ExternalByteEncoding.fromSerializedEncodingParams(params);
                    }
                    case HUFFMAN: {
                        return CanonicalHuffmanByteEncoding.fromSerializedEncodingParams(params);
                    }
                }
                break;
            }
            case INT: {
                switch (encodingID) {
                    case HUFFMAN: {
                        return CanonicalHuffmanIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case GOLOMB: {
                        return GolombIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case GOLOMB_RICE: {
                        return GolombRiceIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case BETA: {
                        return BetaIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case GAMMA: {
                        return GammaIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                    case SUBEXPONENTIAL: {
                        return SubexponentialIntegerEncoding.fromSerializedEncodingParams(params);
                    }
                }
            }
            case LONG: {
                switch (encodingID) {
                    case GOLOMB: {
                        return GolombLongEncoding.fromSerializedEncodingParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalLongEncoding.fromSerializedEncodingParams(params);
                    }
                }
            }
            case BYTE_ARRAY: {
                switch (encodingID) {
                    case BYTE_ARRAY_LEN: {
                        return ByteArrayLenEncoding.fromSerializedEncodingParams(params);
                    }
                    case BYTE_ARRAY_STOP: {
                        return ByteArrayStopEncoding.fromSerializedEncodingParams(params);
                    }
                    case EXTERNAL: {
                        return ExternalByteArrayEncoding.fromSerializedEncodingParams(params);
                    }
                }
            }
        }
        throw new IllegalArgumentException("Encoding not found: value type=" + valueType.name() + ", encoding id=" + encodingID.name());
    }
}

