/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam;

import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import org.apache.log4j.Logger;
import org.broad.igv.feature.SpliceJunctionFeature;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.renderer.DataRange;
import org.broad.igv.renderer.SpliceJunctionRenderer;
import org.broad.igv.sam.AlignmentDataManager;
import org.broad.igv.sam.AlignmentInterval;
import org.broad.igv.sam.AlignmentTrack;
import org.broad.igv.sam.CoverageTrack;
import org.broad.igv.sam.SpliceJunctionHelper;
import org.broad.igv.sashimi.SashimiPlot;
import org.broad.igv.track.FeatureTrack;
import org.broad.igv.track.PackedFeaturesSpliceJunctions;
import org.broad.igv.track.RegionScoreType;
import org.broad.igv.track.RenderContext;
import org.broad.igv.track.Track;
import org.broad.igv.track.TrackClickEvent;
import org.broad.igv.track.TrackMenuUtils;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.panel.IGVPopupMenu;
import org.broad.igv.ui.panel.ReferenceFrame;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpliceJunctionTrack
extends FeatureTrack {
    private static Logger log = Logger.getLogger(SpliceJunctionTrack.class);
    private static StrandOption strandOption;
    private AlignmentTrack alignmentTrack;
    private AlignmentDataManager dataManager;
    private boolean removed = false;
    private JComponent dataPanel;

    public static void setStrandOption(StrandOption so) {
        strandOption = so;
    }

    public static StrandOption getStrandOption() {
        return strandOption;
    }

    public SpliceJunctionTrack(ResourceLocator locator, String name, AlignmentDataManager dataManager, AlignmentTrack alignmentTrack, StrandOption ignoreStrand) {
        super(locator, locator.getPath() + "_junctions", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.setRendererClass(SpliceJunctionRenderer.class);
        if (dataManager != null) {
            dataManager.unsubscribe(this);
        }
        this.dataManager = dataManager;
        this.dataManager.subscribe(this);
        this.alignmentTrack = alignmentTrack;
        strandOption = ignoreStrand;
    }

    public SpliceJunctionTrack() {
    }

    @Override
    protected boolean isShowFeatures(ReferenceFrame frame) {
        float maxRange = PreferencesManager.getPreferences().getAsFloat("SAM.MAX_VISIBLE_RANGE");
        float minVisibleScale = maxRange * 1000.0f / 700.0f;
        return frame.getScale() < (double)minVisibleScale;
    }

    public boolean isRemoved() {
        return this.removed;
    }

    public void clear() {
        this.packedFeaturesMap.clear();
    }

    @Override
    public void dispose() {
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            if (visible) {
                this.dataManager.initLoadOptions();
            }
            if (IGV.hasInstance()) {
                IGV.getInstance().getMainPanel().revalidate();
            }
        }
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu popupMenu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = popupMenu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            popupMenu.add(popupTitle);
        }
        popupMenu.addSeparator();
        ArrayList<Track> tmp = new ArrayList<Track>();
        tmp.add(this);
        TrackMenuUtils.addStandardItems(popupMenu, tmp, te);
        popupMenu.addSeparator();
        popupMenu.add(this.getChangeAutoScale());
        popupMenu.addSeparator();
        JMenuItem sashimi = new JMenuItem("Sashimi Plot");
        sashimi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SashimiPlot.getSashimiPlot(null);
            }
        });
        popupMenu.add(sashimi);
        if (this.alignmentTrack != null) {
            popupMenu.addSeparator();
            final JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
            alignmentItem.setSelected(this.alignmentTrack.isVisible());
            alignmentItem.setEnabled(!this.alignmentTrack.isRemoved());
            alignmentItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpliceJunctionTrack.this.alignmentTrack.setVisible(alignmentItem.isSelected());
                }
            });
            popupMenu.add(alignmentItem);
            final CoverageTrack coverageTrack = this.alignmentTrack.getCoverageTrack();
            if (coverageTrack != null) {
                final JCheckBoxMenuItem coverageItem = new JCheckBoxMenuItem("Show Coverage Track");
                coverageItem.setSelected(coverageTrack.isVisible());
                coverageItem.setEnabled(!coverageTrack.isRemoved());
                coverageItem.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        UIUtilities.invokeOnEventThread(new Runnable(){

                            @Override
                            public void run() {
                                coverageTrack.setVisible(coverageItem.isSelected());
                                IGV.getInstance().getMainPanel().revalidate();
                            }
                        });
                    }
                });
                popupMenu.add(coverageItem);
            }
            JMenuItem junctionItem = new JMenuItem("Hide Splice Junction Track");
            junctionItem.setEnabled(!this.isRemoved());
            junctionItem.addActionListener(e -> this.setVisible(false));
            popupMenu.add(junctionItem);
        }
        return popupMenu;
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    protected String getZoomInMessage(String chr) {
        return "Zoom in to see junctions.";
    }

    @Override
    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        AlignmentInterval loadedInterval;
        ReferenceFrame frame = context.getReferenceFrame();
        if (!this.packedFeaturesMap.containsKey(frame.getName()) && (loadedInterval = this.dataManager.getLoadedInterval(frame)) != null) {
            SpliceJunctionHelper helper = loadedInterval.getSpliceJunctionHelper();
            List<SpliceJunctionFeature> features = helper.getFilteredJunctions(strandOption);
            if (features == null) {
                features = Collections.emptyList();
            }
            int intervalStart = loadedInterval.getStart();
            int intervalEnd = loadedInterval.getEnd();
            PackedFeaturesSpliceJunctions<SpliceJunctionFeature> pf = new PackedFeaturesSpliceJunctions<SpliceJunctionFeature>(frame.getChrName(), intervalStart, intervalEnd, features.iterator(), this.getName());
            this.packedFeaturesMap.put(frame.getName(), pf);
        }
        super.renderFeatures(context, inputRect);
    }

    @Override
    public void load(ReferenceFrame frame) {
        this.dataManager.load(frame, this.alignmentTrack.renderOptions, true);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        if (frame.getChrName().equals("All") || frame.getScale() > this.dataManager.getMinVisibleScale()) {
            return true;
        }
        if (!this.dataManager.isLoaded(frame)) {
            this.packedFeaturesMap.clear();
            return false;
        }
        return true;
    }

    @Override
    public String getExportTrackLine() {
        return "track graphType=junctions";
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        boolean result = super.handleDataClick(te);
        if (this.dataPanel != null) {
            this.dataPanel.repaint();
        }
        return result;
    }

    private JMenuItem getChangeAutoScale() {
        final JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        boolean autoScale = this.getAutoScale();
        autoscaleItem.setSelected(autoScale);
        autoscaleItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                boolean autoScale = SpliceJunctionTrack.this.getAutoScale();
                TrackProperties tp = new TrackProperties();
                if (autoScale) {
                    tp.setAutoScale(false);
                    autoscaleItem.setSelected(false);
                } else {
                    tp.setAutoScale(true);
                    autoscaleItem.setSelected(true);
                }
                tp.setRendererClass(SpliceJunctionRenderer.class);
                SpliceJunctionTrack.this.setProperties(tp);
                if (SpliceJunctionTrack.this.dataPanel != null) {
                    SpliceJunctionTrack.this.dataPanel.repaint();
                }
            }
        });
        return autoscaleItem;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        if (this.removed) {
            element.setAttribute("removed", String.valueOf(this.removed));
        }
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("removed")) {
            this.removed = Boolean.parseBoolean("removed");
        }
    }

    public static enum StrandOption {
        COMBINE,
        FORWARD,
        REVERSE,
        BOTH;

    }
}

