/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.bedpe;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.Globals;
import org.broad.igv.bedpe.BedPEFeature;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.track.TrackProperties;
import org.broad.igv.ui.color.ColorUtilities;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class BedPEParser {
    private static Logger log = Logger.getLogger(BedPEParser.class);

    public static Dataset parse(ResourceLocator locator, Genome genome) throws IOException {
        String nextLine;
        int colorColumn = -1;
        int thicknessColumn = -1;
        DatasetType type = DatasetType.UNKNOWN;
        boolean parsedHeader = true;
        boolean col7isNumeric = true;
        HashMap<String, Color> colorCache = new HashMap<String, Color>();
        ArrayList<BedPEFeature> features = new ArrayList<BedPEFeature>();
        BufferedReader br = null;
        br = ParsingUtils.openBufferedReader(locator.getPath());
        while ((nextLine = br.readLine()) != null) {
            if (nextLine.startsWith("#columns")) {
                try {
                    String[] t2;
                    String[] t1 = ParsingUtils.WHITESPACE_PATTERN.split(nextLine);
                    if (t1.length != 2) continue;
                    for (String keyValue : t2 = ParsingUtils.SEMI_COLON_PATTERN.split(t1[1])) {
                        String[] t = keyValue.split("=");
                        if (t[0].equals("color")) {
                            colorColumn = Integer.parseInt(t[1]) - 1;
                            continue;
                        }
                        if (!t[0].equals("thickness")) continue;
                        thicknessColumn = Integer.parseInt(t[1]) - 1;
                    }
                    continue;
                }
                catch (NumberFormatException e) {
                    log.error((Object)"Error parsing #column line.", (Throwable)e);
                    continue;
                }
            }
            if (nextLine.startsWith("#")) {
                String[] columns = Globals.tabPattern.split(nextLine);
                if (nextLine.trim().equals("#chrom1\tstart1\tstop1\tchrom2\tstart2\tstop2\tname\tqual\tstrand1\tstrand2\tfilters\tinfo")) {
                    type = DatasetType.TENX;
                    continue;
                }
                for (int i = 6; i < columns.length; ++i) {
                    if (columns[i].equalsIgnoreCase("color")) {
                        colorColumn = i;
                        continue;
                    }
                    if (!columns[i].toLowerCase().equalsIgnoreCase("thickness")) continue;
                    thicknessColumn = i;
                }
                continue;
            }
            if (nextLine.startsWith("track") || nextLine.startsWith("##track")) {
                TrackProperties trackProperties = new TrackProperties();
                ParsingUtils.parseTrackLine(nextLine, trackProperties);
                continue;
            }
            String[] tokens = Globals.tabPattern.split(nextLine);
            if (tokens.length < 6) {
                log.info((Object)("Skipping line: " + nextLine));
                continue;
            }
            String chr1 = genome == null ? tokens[0] : genome.getCanonicalChrName(tokens[0]);
            String chr2 = genome == null ? tokens[3] : genome.getCanonicalChrName(tokens[3]);
            int start1 = Integer.parseInt(tokens[1]);
            int end1 = Integer.parseInt(tokens[2]);
            int start2 = Integer.parseInt(tokens[4]);
            int end2 = Integer.parseInt(tokens[5]);
            BedPEFeature feature = new BedPEFeature(chr1, start1, end1, chr2, start2, end2);
            if (tokens.length > 6) {
                feature.name = tokens[6];
                col7isNumeric = col7isNumeric && BedPEParser.isNumeric(tokens[6]);
            } else {
                col7isNumeric = false;
            }
            if (tokens.length > 7) {
                feature.score = Double.parseDouble(tokens[7]);
            }
            if (type == DatasetType.TENX) {
                String[] kvPairs;
                LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
                if (!tokens[8].equals(".")) {
                    attributes.put("filters", tokens[8]);
                }
                for (String kvPair : kvPairs = Globals.semicolonPattern.split(tokens[11])) {
                    String[] kv = Globals.equalPattern.split(kvPair);
                    attributes.put(kv[0], kv[1]);
                }
                feature.attributes = attributes;
                feature.type = (String)attributes.get("TYPE");
            } else {
                if (colorColumn > 0) {
                    String colorString = tokens[colorColumn];
                    Color c = (Color)colorCache.get(colorString);
                    if (c == null) {
                        c = ColorUtilities.stringToColor(colorString);
                        colorCache.put(colorString, c);
                    }
                    feature.color = c;
                }
                if (thicknessColumn > 0) {
                    feature.thickness = Integer.parseInt(tokens[thicknessColumn]);
                }
            }
            features.add(feature);
        }
        if (col7isNumeric) {
            for (BedPEFeature f : features) {
                f.score = Double.parseDouble(f.name);
                f.name = null;
            }
            if (type == DatasetType.UNKNOWN) {
                type = DatasetType.CLUSTER;
            }
        }
        return new Dataset(type, features);
    }

    public static boolean isNumeric(String strNum) {
        return strNum.matches("-?\\d+(\\.\\d+)?");
    }

    public static class Dataset {
        public DatasetType type;
        public List<BedPEFeature> features;

        public Dataset(DatasetType type, List<BedPEFeature> features) {
            this.type = type;
            this.features = features;
        }
    }

    static enum DatasetType {
        TENX,
        CLUSTER,
        UNKNOWN;

    }
}

