/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.lite;

import htsjdk.samtools.util.StringUtil;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.sam.ReadMate;
import org.broad.igv.sam.SAMAlignment;

public class BAMAlignment
extends SAMAlignment {
    static int READ_PAIRED_FLAG = 1;
    static int PROPER_PAIR_FLAG = 2;
    static int READ_UNMAPPED_FLAG = 4;
    static int MATE_UNMAPPED_FLAG = 8;
    static int READ_STRAND_FLAG = 16;
    static int MATE_STRAND_FLAG = 32;
    static int FIRST_OF_PAIR_FLAG = 64;
    static int SECOND_OF_PAIR_FLAG = 128;
    static int SECONDARY_ALIGNMENT_FLAG = 256;
    static int READ_FAILS_VENDOR_QUALITY_CHECK_FLAG = 512;
    static int DUPLICATE_READ_FLAG = 1024;
    static int SUPPLEMENTARY_ALIGNMENT_FLAG = 2048;
    public int flags;
    public int fragmentLength;
    public int lengthOnRef;
    public int start;
    public byte[] sequence;
    public byte[] qualities;
    public int mq;
    public String readName;
    public byte[] tagBytes;
    public byte[] cigarBytes;
    public String chr;
    public ReadMate mate;
    private Map<String, Object> tagDictionary;

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public int getMappingQuality() {
        return this.mq;
    }

    @Override
    public int getInferredInsertSize() {
        return 0;
    }

    @Override
    public String getCigarString() {
        return new String(this.cigarBytes);
    }

    @Override
    public int getReadLength() {
        return this.sequence.length;
    }

    @Override
    public String getReadSequence() {
        return new String(this.sequence);
    }

    @Override
    public boolean isNegativeStrand() {
        return (this.flags & READ_STRAND_FLAG) != 0;
    }

    @Override
    public boolean isFirstOfPair() {
        return (this.flags & FIRST_OF_PAIR_FLAG) != 0;
    }

    @Override
    public boolean isSecondOfPair() {
        return (this.flags & SECOND_OF_PAIR_FLAG) != 0;
    }

    @Override
    public boolean isDuplicate() {
        return (this.flags & DUPLICATE_READ_FLAG) != 0;
    }

    @Override
    public boolean isMapped() {
        return (this.flags & READ_UNMAPPED_FLAG) == 0;
    }

    @Override
    public boolean isPaired() {
        return (this.flags & READ_PAIRED_FLAG) != 0;
    }

    @Override
    public boolean isProperPair() {
        return (this.flags & PROPER_PAIR_FLAG) != 0;
    }

    @Override
    public boolean isSupplementary() {
        return (this.flags & SUPPLEMENTARY_ALIGNMENT_FLAG) != 0;
    }

    @Override
    public boolean isVendorFailedRead() {
        return (this.flags & READ_FAILS_VENDOR_QUALITY_CHECK_FLAG) != 0;
    }

    @Override
    public boolean isPrimary() {
        return (this.flags & SECONDARY_ALIGNMENT_FLAG) == 0;
    }

    @Override
    public int getAlignmentStart() {
        return this.start;
    }

    @Override
    public int getAlignmentEnd() {
        return this.start + this.lengthOnRef;
    }

    @Override
    public Object getAttribute(String key) {
        return null;
    }

    @Override
    public String getSample() {
        return null;
    }

    @Override
    public String getReadGroup() {
        return null;
    }

    @Override
    public String getLibrary() {
        return null;
    }

    @Override
    public String getAttributeString(boolean truncate) {
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        ArrayList<String> tagsToHide = new ArrayList<String>();
        ArrayList<String> tagsHidden = new ArrayList<String>();
        String samHiddenTagsPref = prefMgr.get("SAM.HIDDEN_TAGS");
        for (String s : (samHiddenTagsPref == null ? "" : samHiddenTagsPref).split("[, ]")) {
            if (s.equals("")) continue;
            tagsToHide.add(s);
        }
        StringBuffer buf = new StringBuffer();
        Map<String, Object> attributes = this.getTagDictionary();
        if (attributes != null && !attributes.isEmpty()) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String tag = entry.getKey();
                Object value = entry.getValue();
                if (tagsToHide.contains(tag)) {
                    tagsHidden.add(tag);
                    continue;
                }
                buf.append("<br>" + tag + " = ");
                if (value.getClass().isArray()) {
                    buf.append("[not shown]<br>");
                    continue;
                }
                String tagValue = value.toString();
                int maxLength = 70;
                if (tagValue.length() > 70 && truncate) {
                    String[] tokens;
                    for (String token : tokens = tagValue.split("<br>")) {
                        if (token.length() > 70) {
                            String remainder = token;
                            while (remainder.length() > 70) {
                                String tmp = remainder.substring(0, 70);
                                int spaceIndex = tmp.lastIndexOf(32);
                                int idx = spaceIndex > 30 ? spaceIndex : 70;
                                String substring = remainder.substring(0, idx);
                                buf.append(substring);
                                buf.append("<br>");
                                remainder = remainder.substring(idx);
                            }
                            buf.append(remainder);
                            buf.append("<br>");
                            continue;
                        }
                        buf.append(token);
                        buf.append("<br>");
                    }
                    continue;
                }
                buf.append(tagValue);
            }
            if (tagsHidden.size() > 0) {
                buf.append("<br>Hidden tags: " + String.join((CharSequence)", ", tagsHidden));
            }
        }
        return buf.toString();
    }

    private Map<String, Object> getTagDictionary() {
        if (this.tagDictionary == null) {
            if (this.tagBytes == null) {
                return null;
            }
            this.tagDictionary = this.decodeTags(this.tagBytes);
        }
        return this.tagDictionary;
    }

    private Map<String, Object> decodeTags(byte[] ba) {
        LinkedHashMap<String, Object> tags = new LinkedHashMap<String, Object>();
        ByteBuffer byteBuffer = ByteBuffer.wrap(ba);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        while (byteBuffer.hasRemaining()) {
            Object value;
            int p = byteBuffer.position();
            String tag = new String(ba, p, 2);
            byteBuffer.position(p + 2);
            char type = (char)byteBuffer.get();
            switch (type) {
                case 'Z': {
                    value = BAMAlignment.readNullTerminatedString(byteBuffer);
                    break;
                }
                case 'A': {
                    value = Character.valueOf((char)byteBuffer.get());
                    break;
                }
                case 'I': {
                    long val = (long)byteBuffer.getInt() & 0xFFFFFFFFL;
                    if (val <= Integer.MAX_VALUE) {
                        value = (int)val;
                        break;
                    }
                    value = val;
                    break;
                }
                case 'i': {
                    value = byteBuffer.getInt();
                    break;
                }
                case 's': {
                    value = byteBuffer.getShort();
                    break;
                }
                case 'S': {
                    value = byteBuffer.getShort() & 0xFFFF;
                    break;
                }
                case 'c': {
                    value = byteBuffer.get();
                    break;
                }
                case 'C': {
                    value = byteBuffer.get() & 0xFF;
                    break;
                }
                case 'f': {
                    value = Float.valueOf(byteBuffer.getFloat());
                    break;
                }
                case 'H': {
                    String hexRep = BAMAlignment.readNullTerminatedString(byteBuffer);
                    value = StringUtil.hexStringToBytes((String)hexRep);
                    break;
                }
                case 'B': {
                    value = BAMAlignment.readArray(byteBuffer);
                    break;
                }
                default: {
                    value = "Unrecognized tag type: " + type;
                }
            }
            tags.put(tag, value);
        }
        return tags;
    }

    private static String readNullTerminatedString(ByteBuffer byteBuffer) {
        byteBuffer.mark();
        int startPosition = byteBuffer.position();
        while (byteBuffer.get() != 0) {
        }
        int endPosition = byteBuffer.position();
        byte[] buf = new byte[endPosition - startPosition - 1];
        byteBuffer.reset();
        byteBuffer.get(buf);
        byteBuffer.get();
        return StringUtil.bytesToString((byte[])buf);
    }

    private static Object readArray(ByteBuffer byteBuffer) {
        Object[] value;
        byte arrayType = byteBuffer.get();
        boolean isUnsigned = Character.isUpperCase(arrayType);
        int length = byteBuffer.getInt();
        switch (Character.toLowerCase(arrayType)) {
            case 99: {
                byte[] array;
                value = array = new byte[length];
                byteBuffer.get(array);
                break;
            }
            case 115: {
                short[] array = new short[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getShort();
                }
                break;
            }
            case 105: {
                int[] array = new int[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getInt();
                }
                break;
            }
            case 102: {
                float[] array = new float[length];
                value = array;
                for (int i = 0; i < length; ++i) {
                    array[i] = byteBuffer.getFloat();
                }
                break;
            }
            default: {
                throw new RuntimeException("Unrecognized tag array type: " + (char)arrayType);
            }
        }
        return value;
    }
}

