/*
 * Decompiled with CFR 0.152.
 */
package org.bdval.io.compound;

import java.io.ByteArrayInputStream;
import java.io.DataInput;
import java.io.EOFException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.RandomAccessFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CompoundDataInput
implements DataInput {
    private static final Log LOG = LogFactory.getLog(CompoundDataInput.class);
    private RandomAccessFile dataInput;
    private long fileSize;

    CompoundDataInput(RandomAccessFile input, long fileSize) {
        this.dataInput = input;
        this.fileSize = fileSize;
    }

    @Override
    public void readFully(byte[] b) throws IOException {
        this.fileSize -= (long)b.length;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        this.dataInput.readFully(b);
    }

    @Override
    public void readFully(byte[] b, int off, int len) throws IOException {
        this.fileSize -= (long)len;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        this.dataInput.readFully(b, off, len);
    }

    @Override
    public int skipBytes(int n) throws IOException {
        this.fileSize -= (long)n;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.skipBytes(n);
    }

    @Override
    public boolean readBoolean() throws IOException {
        --this.fileSize;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readBoolean();
    }

    @Override
    public byte readByte() throws IOException {
        --this.fileSize;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        --this.fileSize;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        this.fileSize -= 2L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        this.fileSize -= 16L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readUnsignedShort();
    }

    @Override
    public char readChar() throws IOException {
        --this.fileSize;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readChar();
    }

    @Override
    public int readInt() throws IOException {
        this.fileSize -= 4L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readInt();
    }

    @Override
    public long readLong() throws IOException {
        this.fileSize -= 8L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        this.fileSize -= 4L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        this.fileSize -= 8L;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        return this.dataInput.readDouble();
    }

    @Override
    public String readLine() throws IOException {
        StringBuffer line = new StringBuffer();
        int b = -1;
        while (b != 10) {
            b = this.readByte();
            line.append((char)b);
        }
        return line.toString();
    }

    @Override
    public String readUTF() throws IOException {
        long position = this.dataInput.getChannel().position();
        short stringLength = this.readShort();
        this.dataInput.seek(position);
        this.fileSize -= (long)stringLength;
        if (this.fileSize < 0L) {
            throw new EOFException();
        }
        String token = this.dataInput.readUTF();
        return token;
    }

    public long length() throws IOException {
        return Math.min(this.fileSize, this.dataInput.length());
    }

    public Object readObject() throws IOException, ClassNotFoundException {
        int size = this.readInt();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Reading an object that should be " + (size + 4) + " bytes long"));
        }
        byte[] buf = new byte[size];
        this.readFully(buf);
        ByteArrayInputStream bis = new ByteArrayInputStream(buf);
        ObjectInputStream ois = new ObjectInputStream(bis);
        Object deserializedObject = ois.readObject();
        ois.close();
        return deserializedObject;
    }
}

