/*
 * Decompiled with CFR 0.152.
 */
package edu.cornell.med.icb.goby.util;

import org.apache.commons.logging.Log;
import org.apache.log4j.Logger;

public class WarningCounter {
    int counter;
    private int maxWarnings;

    public WarningCounter(int maxWarnings) {
        this.maxWarnings = maxWarnings;
    }

    public WarningCounter() {
        this.maxWarnings = 10;
    }

    public boolean warnAgain() {
        return this.counter++ < this.maxWarnings;
    }

    public void warn(Log log, String format, Object ... option) {
        if (this.warnAgain()) {
            log.warn((Object)String.format(format, option));
        }
    }

    public void warn(Logger log, String format, Object ... option) {
        if (this.warnAgain()) {
            log.warn((Object)String.format(format, option));
        }
    }

    public void info(Log log, String format, Object ... option) {
        if (this.warnAgain()) {
            log.info((Object)String.format(format, option));
        }
    }

    public void info(Logger log, String format, Object ... option) {
        if (this.warnAgain()) {
            log.info((Object)String.format(format, option));
        }
    }

    public void debug(Log log, String format, Object ... option) {
        if (log.isDebugEnabled() && this.warnAgain()) {
            log.debug((Object)String.format(format, option));
        }
    }

    public void debug(Logger log, String format, Object ... option) {
        if (log.isDebugEnabled() && this.warnAgain()) {
            log.debug((Object)String.format(format, option));
        }
    }

    public void trace(Log log, String format, Object ... option) {
        if (log.isTraceEnabled() && this.warnAgain()) {
            log.debug((Object)String.format(format, option));
        }
    }

    public void trace(Logger log, String format, Object ... option) {
        if (log.isTraceEnabled() && this.warnAgain()) {
            log.trace((Object)String.format(format, option));
        }
    }
}

