/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.swing;

import java.awt.Color;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class JToolTipFactory {
    private static JToolTipFactory _tooltipFactory;

    public JToolTip createToolTip(JComponent c) {
        return this.createToolTip(c, false);
    }

    public JToolTip createToolTip(JComponent c, boolean overlapping) {
        JToolTip tt = new JToolTip();
        if (c != null) {
            tt.setComponent(c);
            if (overlapping) {
                if (c.getBackground() != null) {
                    Color bg = c.getBackground();
                    if (bg.getAlpha() != 255) {
                        bg = new Color(bg.getRed(), bg.getGreen(), bg.getBlue());
                    }
                    tt.setBackground(bg);
                }
                if (c.getForeground() != null) {
                    tt.setForeground(c.getForeground());
                }
                if (c.getFont() != null) {
                    tt.setFont(c.getFont());
                }
            }
        }
        return tt;
    }

    public static void setSharedInstance(JToolTipFactory factory) {
        if (factory == null) {
            throw new IllegalArgumentException("JToolTipFactory can not be null");
        }
        _tooltipFactory = factory;
    }

    public static JToolTipFactory getSharedInstance() {
        if (_tooltipFactory == null) {
            _tooltipFactory = new JToolTipFactory();
        }
        return _tooltipFactory;
    }
}

