/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import org.broad.igv.track.AttributeManager;
import org.broad.igv.ui.AttributeSelectionDialog;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.action.MenuAction;
import org.broad.igv.ui.util.UIUtilities;

public class GroupTracksMenuAction
extends MenuAction {
    IGV mainFrame;

    public GroupTracksMenuAction(String label, int mnemonic, IGV mainFrame) {
        super(label, null, mnemonic);
        this.mainFrame = mainFrame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.doGroupBy();
    }

    public final void doGroupBy() {
        UIUtilities.invokeOnEventThread(new Runnable(){

            @Override
            public void run() {
                GroupTracksMenuAction groupTracksMenuAction = GroupTracksMenuAction.this;
                AttributeSelectionDialog dlg = new AttributeSelectionDialog(groupTracksMenuAction.mainFrame.getMainFrame(), true);
                List<String> attributeKeys = AttributeManager.getInstance().getVisibleAttributes();
                ArrayList<String> selections = new ArrayList<String>(attributeKeys);
                selections.add(0, "None");
                String[] selArray = selections.toArray(new String[0]);
                dlg.setModel(new DefaultComboBoxModel<String>(selArray));
                dlg.setDefaultCloseOperation(2);
                String currentSelection = IGV.getInstance().getGroupByAttribute();
                if (currentSelection == null) {
                    dlg.setSelectedIndex(0);
                } else {
                    dlg.setSelectedItem(currentSelection);
                }
                dlg.setVisible(true);
                if (!dlg.isCanceled()) {
                    int selIndex = dlg.getSelectedIndex();
                    String selectedAttribute = selIndex == 0 ? null : selArray[selIndex];
                    IGV.getInstance().setGroupByAttribute(selectedAttribute);
                    GroupTracksMenuAction.this.mainFrame.doRefresh();
                }
            }
        });
    }
}

