/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui;

import com.jidesoft.plaf.LookAndFeelFactory;
import com.sanityinc.jargs.CmdLineParser;
import htsjdk.samtools.seekablestream.ISeekableStreamFactory;
import htsjdk.samtools.seekablestream.SeekableStreamFactory;
import java.awt.Color;
import java.awt.Frame;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import org.apache.log4j.Logger;
import org.broad.igv.DirectoryManager;
import org.broad.igv.Globals;
import org.broad.igv.prefs.IGVPreferences;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.DefaultExceptionHandler;
import org.broad.igv.ui.DesktopIntegration;
import org.broad.igv.ui.FontManager;
import org.broad.igv.ui.GlobalKeyDispatcher;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.ShutdownThread;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.RuntimeUtils;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class Main {
    private static Logger log = Logger.getLogger(Main.class);

    public static void main(String[] args) {
        Thread.setDefaultUncaughtExceptionHandler(new DefaultExceptionHandler());
        final IGVArgs igvArgs = new IGVArgs(args);
        if (igvArgs.igvDirectory != null) {
            Main.setIgvDirectory(igvArgs);
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                if (Globals.IS_WINDOWS && System.getProperty("os.name").contains("10")) {
                    UIManager.put("FileChooser.useSystemExtensionHiding", false);
                }
                DesktopIntegration.verifyJavaPlatform();
                Main.initApplication();
                JFrame frame = new JFrame();
                frame.setDefaultCloseOperation(3);
                ImageIcon icon = new ImageIcon(Main.class.getResource("mainframeicon.png"));
                if (icon != null) {
                    frame.setIconImage(icon.getImage());
                }
                Main.open(frame, igvArgs);
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private static void setIgvDirectory(IGVArgs igvArgs) {
        File dir = new File(igvArgs.igvDirectory);
        if (!dir.exists()) {
            try {
                if (dir.mkdir()) {
                    DirectoryManager.setIgvDirectory(dir);
                }
                log.error((Object)("Unable to create igv directory " + dir.getAbsolutePath()));
            }
            catch (Exception e) {
                log.error((Object)("Error creating igv directory " + dir.getAbsolutePath()), (Throwable)e);
                return;
            }
        } else if (dir.isDirectory()) {
            if (dir.canWrite()) {
                DirectoryManager.setIgvDirectory(dir);
            } else {
                log.error((Object)("IGV directory '" + dir.getAbsolutePath() + "'is not writable"));
            }
        } else {
            log.error((Object)("'" + dir.getAbsolutePath() + "' is not a directory"));
        }
    }

    private static void initApplication() {
        int MB;
        long mem = RuntimeUtils.getAvailableMemory();
        if (mem < (long)(400 * (MB = 1000000))) {
            int mb = (int)(mem / (long)MB);
            JOptionPane.showMessageDialog(null, "Warning: IGV is running with low available memory (" + mb + " mb)");
        }
        DirectoryManager.initializeLog();
        log.info((Object)("Startup  " + Globals.applicationString()));
        log.info((Object)("Java " + System.getProperty("java.version")));
        log.info((Object)("Default User Directory: " + DirectoryManager.getUserDirectory()));
        log.info((Object)("OS: " + System.getProperty("os.name")));
        System.setProperty("http.agent", Globals.applicationString());
        Runtime.getRuntime().addShutdownHook(new ShutdownThread());
        Main.updateTooltipSettings();
        System.setProperty("awt.useSystemAAFontSettings", "on");
        System.setProperty("swing.aatext", "true");
        Main.checkVersion();
    }

    public static void updateTooltipSettings() {
        ToolTipManager.sharedInstance().setEnabled(true);
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        ToolTipManager.sharedInstance().setInitialDelay(prefMgr.getAsInt("TOOLTIP.INITIAL_DELAY"));
        ToolTipManager.sharedInstance().setReshowDelay(prefMgr.getAsInt("TOOLTIP.RESHOW_DELAY"));
        ToolTipManager.sharedInstance().setDismissDelay(prefMgr.getAsInt("TOOLTIP.DISMISS_DELAY"));
    }

    private static void checkVersion() {
        Runnable runnable = () -> {
            block9: {
                try {
                    Version thisVersion = Version.getVersion(Globals.VERSION);
                    if (thisVersion != null) {
                        HashSet<String> skipVersion;
                        String serverVersionString = HttpUtils.getInstance().getContentsAsString(new URL(Globals.getVersionURL())).trim();
                        String skipString = PreferencesManager.getPreferences().get("SKIP_VERSION");
                        if (skipString != null && (skipVersion = new HashSet<String>(Arrays.asList(skipString.split(",")))).contains(serverVersionString)) {
                            return;
                        }
                        Version serverVersion = Version.getVersion(serverVersionString.trim());
                        if (serverVersion == null) {
                            return;
                        }
                        if (thisVersion.lessThan(serverVersion)) {
                            log.info((Object)("A later version of IGV is available (" + serverVersionString + ")"));
                        }
                        break block9;
                    }
                    if (Globals.VERSION.contains("3.0_beta") || Globals.VERSION.contains("snapshot")) {
                        HttpUtils.getInstance().getContentsAsString(new URL(Globals.getVersionURL())).trim();
                        break block9;
                    }
                    log.info((Object)("Unknown version: " + Globals.VERSION));
                }
                catch (Exception e) {
                    log.error((Object)"Error checking version", (Throwable)e);
                }
            }
        };
        new Thread(runnable).start();
    }

    public static void open(Frame frame) {
        Main.open(frame, new IGVArgs(new String[0]));
    }

    public static void open(Frame frame, IGVArgs igvArgs) {
        if (!(frame instanceof JFrame)) {
            frame.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(WindowEvent windowEvent) {
                    windowEvent.getComponent().setVisible(false);
                }
            });
        }
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowActivated(WindowEvent e) {
                ToolTipManager.sharedInstance().setEnabled(true);
            }

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                this.windowActivated(windowEvent);
            }
        });
        Main.initializeLookAndFeel();
        if (igvArgs.getPropertyOverrides() != null) {
            PreferencesManager.loadOverrides(igvArgs.getPropertyOverrides());
        }
        if (igvArgs.getDataServerURL() != null) {
            PreferencesManager.getPreferences().overrideDataServerURL(igvArgs.getDataServerURL());
        }
        if (igvArgs.getGenomeServerURL() != null) {
            PreferencesManager.getPreferences().overrideGenomeServerURL(igvArgs.getGenomeServerURL());
        }
        HttpUtils.getInstance().updateProxySettings();
        SeekableStreamFactory.setInstance((ISeekableStreamFactory)IGVSeekableStreamFactory.getInstance());
        RuntimeUtils.loadPluginJars();
        IGV.createInstance(frame).startUp(igvArgs);
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventDispatcher(new GlobalKeyDispatcher());
    }

    private static void initializeLookAndFeel() {
        try {
            String lnf = UIManager.getSystemLookAndFeelClassName();
            UIManager.setLookAndFeel(lnf);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        double resolutionScale = Toolkit.getDefaultToolkit().getScreenResolution() / 96;
        IGVPreferences prefMgr = PreferencesManager.getPreferences();
        if (resolutionScale > 1.5) {
            if (prefMgr.getAsBoolean("SCALE_FONTS")) {
                FontManager.scaleFontSize(resolutionScale);
            } else if (prefMgr.hasExplicitValue("DEFAULT_FONT_SIZE")) {
                int fs = prefMgr.getAsInt("DEFAULT_FONT_SIZE");
                FontManager.updateSystemFontSize(fs);
            }
        }
        if (Globals.IS_LINUX) {
            try {
                UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                UIManager.put("JideSplitPane.dividerSize", 5);
                UIManager.put("JideSplitPaneDivider.background", Color.darkGray);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        LookAndFeelFactory.installJideExtension();
    }

    public static class IGVArgs {
        private String batchFile = null;
        private String sessionFile = null;
        private List<String> dataFileStrings = null;
        private String locusString = null;
        private String propertyOverrides = null;
        private String genomeId = null;
        private String port = null;
        private String dataServerURL = null;
        private String genomeServerURL = null;
        private String indexFile = null;
        private String coverageFile = null;
        private String name = null;
        public String igvDirectory = null;
        public String forceVersion = null;

        IGVArgs(String[] args) {
            if (args != null) {
                this.parseArgs(args);
            }
        }

        private void parseArgs(String[] args) {
            String forceVersion;
            String igvDirectoryPath;
            String coverageFilePath;
            CmdLineParser parser = new CmdLineParser();
            CmdLineParser.Option<String> propertyFileOption = parser.addStringOption('o', "preferences");
            CmdLineParser.Option<String> batchFileOption = parser.addStringOption('b', "batch");
            CmdLineParser.Option<String> portOption = parser.addStringOption('p', "port");
            CmdLineParser.Option<String> genomeOption = parser.addStringOption('g', "genome");
            CmdLineParser.Option<String> dataServerOption = parser.addStringOption('d', "dataServerURL");
            CmdLineParser.Option<String> genomeServerOption = parser.addStringOption('u', "genomeServerURL");
            CmdLineParser.Option<String> indexFileOption = parser.addStringOption('i', "indexFile");
            CmdLineParser.Option<String> coverageFileOption = parser.addStringOption('c', "coverageFile");
            CmdLineParser.Option<String> nameOption = parser.addStringOption('n', "name");
            CmdLineParser.Option<String> locusOption = parser.addStringOption('l', "locus");
            CmdLineParser.Option<String> igvDirectoryOption = parser.addStringOption("igvDirectory");
            CmdLineParser.Option<String> forceVersionOption = parser.addStringOption("forceVersion");
            CmdLineParser.Option<Boolean> versionOption = parser.addBooleanOption("version");
            try {
                parser.parse(args);
            }
            catch (Exception e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, "Error parsing command line argments: " + e.getMessage());
                return;
            }
            this.propertyOverrides = this.getDecodedValue(parser, propertyFileOption);
            this.batchFile = this.getDecodedValue(parser, batchFileOption);
            this.port = parser.getOptionValue(portOption);
            this.genomeId = parser.getOptionValue(genomeOption);
            this.dataServerURL = this.getDecodedValue(parser, dataServerOption);
            this.genomeServerURL = this.getDecodedValue(parser, genomeServerOption);
            this.name = parser.getOptionValue(nameOption);
            this.locusString = parser.getOptionValue(locusOption);
            String indexFilePath = parser.getOptionValue(indexFileOption);
            if (indexFilePath != null) {
                this.indexFile = this.maybeDecodePath(indexFilePath);
            }
            if ((coverageFilePath = parser.getOptionValue(coverageFileOption)) != null) {
                this.coverageFile = this.maybeDecodePath(coverageFilePath);
            }
            if ((igvDirectoryPath = parser.getOptionValue(igvDirectoryOption)) != null) {
                this.igvDirectory = this.maybeDecodePath(igvDirectoryPath);
            }
            if ((forceVersion = parser.getOptionValue(forceVersionOption)) != null) {
                Globals.VERSION = forceVersion;
            }
            String[] nonOptionArgs = parser.getRemainingArgs();
            if (parser.getOptionValue(versionOption) != null) {
                System.out.println(Globals.VERSION);
                System.exit(0);
            }
            if (nonOptionArgs.length > 0) {
                nonOptionArgs = (String[])Arrays.stream(nonOptionArgs).filter(s -> !s.isEmpty()).toArray(String[]::new);
            }
            if (nonOptionArgs != null && nonOptionArgs.length > 0) {
                if (this.locusString != null || nonOptionArgs.length > 2) {
                    this.decodeNonOptionArgs(nonOptionArgs);
                } else if (nonOptionArgs.length == 1) {
                    this.decodeNonOptionArgsLegacy(nonOptionArgs);
                } else {
                    String secondArg = this.maybeDecodePath(nonOptionArgs[1]);
                    if (FileUtils.isRemote(secondArg) || new File(secondArg).exists()) {
                        this.decodeNonOptionArgs(nonOptionArgs);
                    } else {
                        this.decodeNonOptionArgsLegacy(nonOptionArgs);
                    }
                }
            }
        }

        private void decodeNonOptionArgsLegacy(String[] nonOptionArgs) {
            this.dataFileStrings = new ArrayList<String>();
            String firstArg = this.maybeDecodePath(nonOptionArgs[0]);
            if (firstArg != null) {
                log.info((Object)("Loading: " + firstArg));
                if (firstArg.endsWith(".xml") || firstArg.endsWith(".php") || firstArg.endsWith(".php3") || firstArg.endsWith(".session")) {
                    this.sessionFile = firstArg;
                } else {
                    String[] paths;
                    for (String p : paths = firstArg.split(",")) {
                        this.dataFileStrings.add(p);
                    }
                }
            }
            if (nonOptionArgs.length == 2) {
                this.locusString = nonOptionArgs[1];
            }
        }

        private void decodeNonOptionArgs(String[] nonOptionArgs) {
            this.dataFileStrings = new ArrayList<String>();
            for (String arg : nonOptionArgs) {
                this.dataFileStrings.add(this.maybeDecodePath(arg));
            }
        }

        private String maybeDecodePath(String path) {
            if (FileUtils.resourceExists(path)) {
                return path;
            }
            if (FileUtils.isRemote(path)) {
                return URLDecoder.decode(path);
            }
            if (path.contains("%2C") || path.contains("%3F") || path.contains("%2B") || path.contains("%2F")) {
                return URLDecoder.decode(path);
            }
            return path;
        }

        private String getDecodedValue(CmdLineParser parser, CmdLineParser.Option option) {
            String value = (String)parser.getOptionValue(option);
            if (value == null) {
                return null;
            }
            try {
                return URLDecoder.decode(value, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                log.error((Object)e);
                return value;
            }
        }

        public String getBatchFile() {
            return this.batchFile;
        }

        public String getSessionFile() {
            return this.sessionFile;
        }

        public List<String> getDataFileStrings() {
            return this.dataFileStrings;
        }

        public String getLocusString() {
            return this.locusString;
        }

        public String getPropertyOverrides() {
            return this.propertyOverrides;
        }

        public String getGenomeId() {
            return this.genomeId;
        }

        public String getPort() {
            return this.port;
        }

        public String getDataServerURL() {
            return this.dataServerURL;
        }

        public String getGenomeServerURL() {
            return this.genomeServerURL;
        }

        public String getIndexFile() {
            return this.indexFile;
        }

        public String getCoverageFile() {
            return this.coverageFile;
        }

        public String getName() {
            return this.name;
        }
    }

    public static class Version {
        private int major;
        private int minor;
        private int build;

        public static Version getVersion(String versionString) {
            String[] tokens = versionString.split("\\.");
            if (tokens.length < 2) {
                return null;
            }
            try {
                int major = Integer.parseInt(tokens[0]);
                int minor = Integer.parseInt(tokens[1]);
                int build = tokens.length <= 2 ? 0 : Integer.parseInt(tokens[2]);
                return new Version(major, minor, build);
            }
            catch (NumberFormatException e) {
                log.error((Object)("Error parsing version string: " + versionString));
                return null;
            }
        }

        private Version(int major, int minor, int build) {
            this.major = major;
            this.minor = minor;
            this.build = build;
        }

        public int getMajor() {
            return this.major;
        }

        public int getMinor() {
            return this.minor;
        }

        public int getBuild() {
            return this.build;
        }

        public boolean lessThan(Version anotherVersion) {
            if (anotherVersion.major > this.major) {
                return true;
            }
            if (anotherVersion.major < this.major) {
                return false;
            }
            if (anotherVersion.minor > this.minor) {
                return true;
            }
            if (anotherVersion.minor < this.minor) {
                return false;
            }
            return anotherVersion.build > this.build;
        }
    }
}

