/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMBinaryTagAndUnsignedArrayValue;
import htsjdk.samtools.SAMBinaryTagAndValue;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMTag;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.encoding.reader.CramRecordReader;
import htsjdk.samtools.cram.encoding.reader.MultiRefSliceAlignmentSpanReader;
import htsjdk.samtools.cram.io.BitInputStream;
import htsjdk.samtools.cram.io.DefaultBitInputStream;
import htsjdk.samtools.cram.structure.AlignmentSpan;
import htsjdk.samtools.cram.structure.CompressionHeader;
import htsjdk.samtools.cram.structure.block.Block;
import htsjdk.samtools.util.Log;
import htsjdk.samtools.util.SequenceUtil;
import java.io.ByteArrayInputStream;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public class Slice {
    public static final int MULTI_REFERENCE = -2;
    public static final int NO_ALIGNMENT_START = -1;
    public static final int NO_ALIGNMENT_SPAN = 0;
    private static final Log log = Log.getInstance(Slice.class);
    public int sequenceId = -1;
    public int alignmentStart = -1;
    public int alignmentSpan = -1;
    public int nofRecords = -1;
    public long globalRecordCounter = -1L;
    public int nofBlocks = -1;
    public int[] contentIDs;
    public int embeddedRefBlockContentID = -1;
    public byte[] refMD5 = new byte[16];
    public Block headerBlock;
    public Block coreBlock;
    public Block embeddedRefBlock;
    public Map<Integer, Block> external;
    public int offset = -1;
    public long containerOffset = -1L;
    public int size = -1;
    public int index = -1;
    public long bases;
    public SAMBinaryTagAndValue sliceTags;

    private void alignmentBordersSanityCheck(byte[] ref) {
        if (this.sequenceId == -1) {
            return;
        }
        if (this.alignmentStart > 0 && this.sequenceId >= 0 && ref == null) {
            throw new IllegalArgumentException("Mapped slice reference is null.");
        }
        if (this.alignmentStart > ref.length) {
            log.error(String.format("Slice mapped outside of reference: seqID=%d, start=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.globalRecordCounter));
            throw new RuntimeException("Slice mapped outside of the reference.");
        }
        if (this.alignmentStart - 1 + this.alignmentSpan > ref.length) {
            log.warn(String.format("Slice partially mapped outside of reference: seqID=%d, start=%d, span=%d, counter=%d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.globalRecordCounter));
        }
    }

    public boolean validateRefMD5(byte[] ref) {
        if (this.sequenceId == -2) {
            throw new SAMException("Cannot verify a slice with multiple references on a single reference.");
        }
        if (this.sequenceId == -1) {
            return true;
        }
        this.alignmentBordersSanityCheck(ref);
        if (!Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan, this.refMD5)) {
            int shoulderLength = 10;
            String excerpt = Slice.getBrief(this.alignmentStart, this.alignmentSpan, ref, 10);
            if (Slice.validateRefMD5(ref, this.alignmentStart, this.alignmentSpan - 1, this.refMD5)) {
                log.warn(String.format("Reference MD5 matches partially for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
                return true;
            }
            log.error(String.format("Reference MD5 mismatch for slice %d:%d-%d, %s", this.sequenceId, this.alignmentStart, this.alignmentStart + this.alignmentSpan - 1, excerpt));
            return false;
        }
        return true;
    }

    private static boolean validateRefMD5(byte[] ref, int alignmentStart, int alignmentSpan, byte[] expectedMD5) {
        int span = Math.min(alignmentSpan, ref.length - alignmentStart + 1);
        String md5 = SequenceUtil.calculateMD5String(ref, alignmentStart - 1, span);
        return md5.equals(String.format("%032x", new BigInteger(1, expectedMD5)));
    }

    private static String getBrief(int startOneBased, int span, byte[] bases, int shoulderLength) {
        if (span >= bases.length) {
            return new String(bases);
        }
        StringBuilder sb = new StringBuilder();
        int fromInc = startOneBased - 1;
        int toExc = startOneBased + span - 1;
        if ((toExc = Math.min(toExc, bases.length)) - fromInc <= 2 * shoulderLength) {
            sb.append(new String(Arrays.copyOfRange(bases, fromInc, toExc)));
        } else {
            sb.append(new String(Arrays.copyOfRange(bases, fromInc, fromInc + shoulderLength)));
            sb.append("...");
            sb.append(new String(Arrays.copyOfRange(bases, toExc - shoulderLength, toExc)));
        }
        return sb.toString();
    }

    public String toString() {
        return String.format("slice: seqID %d, start %d, span %d, records %d.", this.sequenceId, this.alignmentStart, this.alignmentSpan, this.nofRecords);
    }

    public void setRefMD5(byte[] ref) {
        this.alignmentBordersSanityCheck(ref);
        if (this.sequenceId < 0 && this.alignmentStart < 1) {
            this.refMD5 = new byte[16];
            Arrays.fill(this.refMD5, (byte)0);
            log.debug("Empty slice ref md5 is set.");
        } else {
            int span = Math.min(this.alignmentSpan, ref.length - this.alignmentStart + 1);
            if (this.alignmentStart + span > ref.length + 1) {
                throw new RuntimeException("Invalid alignment boundaries.");
            }
            this.refMD5 = SequenceUtil.calculateMD5(ref, this.alignmentStart - 1, span);
            if (Log.isEnabled(Log.LogLevel.DEBUG)) {
                StringBuilder sb = new StringBuilder();
                int shoulder = 10;
                if (ref.length <= 20) {
                    sb.append(new String(ref));
                } else {
                    sb.append(Slice.getBrief(this.alignmentStart, this.alignmentSpan, ref, 10));
                }
                log.debug(String.format("Slice md5: %s for %d:%d-%d, %s", String.format("%032x", new BigInteger(1, this.refMD5)), this.sequenceId, this.alignmentStart, this.alignmentStart + span - 1, sb.toString()));
            }
        }
    }

    public Object getAttribute(short tag) {
        if (this.sliceTags == null) {
            return null;
        }
        SAMBinaryTagAndValue tmp = this.sliceTags.find(tag);
        if (tmp != null) {
            return tmp.value;
        }
        return null;
    }

    public void setAttribute(String tag, Object value) {
        if (value != null && value.getClass().isArray() && Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty value passed for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value);
    }

    public void setUnsignedArrayAttribute(String tag, Object value) {
        if (!value.getClass().isArray()) {
            throw new IllegalArgumentException("Non-array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        if (Array.getLength(value) == 0) {
            throw new IllegalArgumentException("Empty array passed to setUnsignedArrayAttribute for tag " + tag);
        }
        this.setAttribute(SAMTag.makeBinaryTag(tag), value, true);
    }

    void setAttribute(short tag, Object value) {
        this.setAttribute(tag, value, false);
    }

    void setAttribute(short tag, Object value, boolean isUnsignedArray) {
        if (value == null) {
            if (this.sliceTags != null) {
                this.sliceTags = this.sliceTags.remove(tag);
            }
        } else {
            SAMBinaryTagAndValue tmp = !isUnsignedArray ? new SAMBinaryTagAndValue(tag, value) : new SAMBinaryTagAndUnsignedArrayValue(tag, value);
            this.sliceTags = this.sliceTags == null ? tmp : this.sliceTags.insert(tmp);
        }
    }

    public boolean isMapped() {
        return this.sequenceId > -1;
    }

    public boolean isMultiref() {
        return this.sequenceId == -2;
    }

    private BitInputStream getCoreBlockInputStream() {
        return new DefaultBitInputStream(new ByteArrayInputStream(this.coreBlock.getUncompressedContent()));
    }

    private Map<Integer, ByteArrayInputStream> getExternalBlockInputMap() {
        return this.external.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new ByteArrayInputStream(((Block)e.getValue()).getUncompressedContent())));
    }

    public CramRecordReader createCramRecordReader(CompressionHeader header, ValidationStringency validationStringency) {
        return new CramRecordReader(this.getCoreBlockInputStream(), this.getExternalBlockInputMap(), header, this.sequenceId, validationStringency);
    }

    public Map<Integer, AlignmentSpan> getMultiRefAlignmentSpans(CompressionHeader header, ValidationStringency validationStringency) {
        MultiRefSliceAlignmentSpanReader reader = new MultiRefSliceAlignmentSpanReader(this.getCoreBlockInputStream(), this.getExternalBlockInputMap(), header, validationStringency, this.alignmentStart, this.nofRecords);
        return reader.getReferenceSpans();
    }

    public CRAIEntry getCRAIEntry() {
        return new CRAIEntry(this.sequenceId, this.alignmentStart, this.alignmentSpan, this.containerOffset, this.offset, this.size);
    }

    public CRAIEntry getCRAIEntry(long containerStartOffset) {
        return new CRAIEntry(this.sequenceId, this.alignmentStart, this.alignmentSpan, containerStartOffset, this.offset, this.size);
    }
}

