/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.tribble;

import htsjdk.samtools.util.BlockCompressedInputStream;
import htsjdk.tribble.AsciiFeatureCodec;
import htsjdk.tribble.FeatureCodec;
import htsjdk.tribble.readers.PositionalBufferedStream;
import htsjdk.variant.bcf2.BCF2Codec;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCF3Codec;
import htsjdk.variant.vcf.VCFCodec;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.log4j.Logger;
import org.broad.igv.data.cufflinks.FPKMTrackingCodec;
import org.broad.igv.feature.FeatureType;
import org.broad.igv.feature.dsi.DSICodec;
import org.broad.igv.feature.genome.Genome;
import org.broad.igv.feature.tribble.BCF2WrapperCodec;
import org.broad.igv.feature.tribble.DGVCodec;
import org.broad.igv.feature.tribble.EncodePeakCodec;
import org.broad.igv.feature.tribble.GFFCodec;
import org.broad.igv.feature.tribble.IGVBEDCodec;
import org.broad.igv.feature.tribble.IntervalListCodec;
import org.broad.igv.feature.tribble.MUTCodec;
import org.broad.igv.feature.tribble.PAFCodec;
import org.broad.igv.feature.tribble.PSLCodec;
import org.broad.igv.feature.tribble.REPMaskCodec;
import org.broad.igv.feature.tribble.UCSCGeneTableCodec;
import org.broad.igv.feature.tribble.UCSCSnpCodec;
import org.broad.igv.feature.tribble.VCFWrapperCodec;
import org.broad.igv.gwas.EQTLCodec;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.HttpUtils;
import org.broad.igv.util.ParsingUtils;
import org.broad.igv.util.ResourceLocator;

public class CodecFactory {
    private static Logger log = Logger.getLogger(CodecFactory.class);
    public static final List<String> validExtensions = new ArrayList<String>(15);

    @Deprecated
    public static FeatureCodec getCodec(String path, Genome genome) {
        return CodecFactory.getCodec(new ResourceLocator(path), genome);
    }

    public static FeatureCodec getCodec(ResourceLocator locator, Genome genome) {
        String path = locator.getPath();
        String fn = locator.getTypeString().toLowerCase();
        if (fn.endsWith(".vcf3")) {
            return new VCFWrapperCodec((AsciiFeatureCodec)new VCF3Codec(), genome);
        }
        if (fn.endsWith(".vcf4")) {
            return new VCFWrapperCodec((AsciiFeatureCodec)new VCFCodec(), genome);
        }
        if (fn.endsWith(".vcf")) {
            return new VCFWrapperCodec(CodecFactory.getVCFCodec(locator), genome);
        }
        if (fn.endsWith(".bcf")) {
            return new BCF2WrapperCodec((FeatureCodec<VariantContext, PositionalBufferedStream>)new BCF2Codec(), genome);
        }
        if (fn.endsWith(".bed")) {
            IGVBEDCodec codec = new IGVBEDCodec(genome);
            if (fn.endsWith("junctions.bed")) {
                codec.setFeatureType(FeatureType.SPLICE_JUNCTION);
            }
            return codec;
        }
        if (fn.endsWith(".gappedpeak")) {
            return new IGVBEDCodec(genome, FeatureType.GAPPED_PEAK);
        }
        if (fn.endsWith(".dgv")) {
            return new DGVCodec(genome);
        }
        if (fn.endsWith(".rmask") || fn.endsWith(".repmask")) {
            return new REPMaskCodec(genome);
        }
        if (fn.endsWith(".gff3") || fn.endsWith(".gvf")) {
            return new GFFCodec(GFFCodec.Version.GFF3, genome);
        }
        if (fn.endsWith(".gff")) {
            return new GFFCodec(genome);
        }
        if (fn.endsWith(".gtf")) {
            return new GFFCodec(GFFCodec.Version.GTF, genome);
        }
        if (fn.endsWith(".psl") || fn.endsWith(".pslx")) {
            return new PSLCodec(genome);
        }
        if (MUTCodec.isMutationAnnotationFile(locator)) {
            return new MUTCodec(path, genome);
        }
        if (fn.endsWith(".narrowpeak") || fn.endsWith(".broadpeak")) {
            return new EncodePeakCodec(genome);
        }
        if (fn.endsWith(".snp") || fn.endsWith(".ucscsnp")) {
            return new UCSCSnpCodec(genome);
        }
        if (fn.endsWith(".eqtl")) {
            return new EQTLCodec(genome);
        }
        if (fn.endsWith("fpkm_tracking")) {
            return new FPKMTrackingCodec(path);
        }
        if (fn.endsWith(".dsi")) {
            return new DSICodec(genome);
        }
        if (fn.endsWith(".paf")) {
            return new PAFCodec(path, genome);
        }
        if (fn.endsWith(".interval_list")) {
            return new IntervalListCodec(genome);
        }
        if (fn.contains("refflat")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.REFFLAT, genome);
        }
        if (fn.contains("genepred") || fn.contains("ensgene") || fn.contains("refgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.GENEPRED, genome);
        }
        if (fn.contains("ucscgene")) {
            return new UCSCGeneTableCodec(UCSCGeneTableCodec.Type.UCSCGENE, genome);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static AsciiFeatureCodec getVCFCodec(ResourceLocator locator) {
        String path = locator.getPath();
        if (FileUtils.isRemote(path)) {
            try {
                path = HttpUtils.createURL(path).toString();
            }
            catch (MalformedURLException e) {
                log.error((Object)"Eror translating url", (Throwable)e);
            }
        }
        BufferedReader reader = null;
        try {
            String formatLine;
            reader = locator.getURLPath().toLowerCase().endsWith(".gz") ? new BufferedReader(new InputStreamReader((InputStream)new BlockCompressedInputStream(htsjdk.tribble.util.ParsingUtils.openInputStream((String)path)))) : ParsingUtils.openBufferedReader(path);
            int lineCount = 0;
            while ((formatLine = reader.readLine()) != null) {
                String[] tmp;
                if (lineCount >= 20) return new VCFCodec();
                if ((formatLine.toLowerCase().startsWith("##fileformat") || formatLine.toLowerCase().startsWith("##format")) && (tmp = formatLine.split("=")).length > 1) {
                    String version = tmp[1].toLowerCase();
                    if (version.startsWith("vcfv3")) {
                        VCF3Codec vCF3Codec = new VCF3Codec();
                        return vCF3Codec;
                    }
                    VCFCodec vCFCodec = new VCFCodec();
                    return vCFCodec;
                }
                ++lineCount;
            }
            return new VCFCodec();
        }
        catch (IOException e) {
            log.error((Object)"Error checking VCF Version");
            return new VCFCodec();
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public static boolean hasCodec(ResourceLocator locator, Genome genome) {
        String fn = locator.getTypeString();
        if (fn.endsWith(".gz")) {
            int l = fn.length() - 3;
            fn = fn.substring(0, l);
        }
        return fn.endsWith(".vcf") || fn.endsWith(".bcf") || CodecFactory.getCodec(locator, genome) != null;
    }

    static {
        validExtensions.addAll(Arrays.asList("vcf4", "vcf", "bed", "refflat", "genepred", "ensgene", "refgene", "ucscgene", "repmask", "gff3", "gvf", "gff", "gtf", "psl", "mut", "maf"));
    }
}

