/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.commandbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.apache.log4j.Logger;
import org.broad.igv.event.GenomeResetEvent;
import org.broad.igv.event.IGVEventBus;
import org.broad.igv.feature.genome.GenomeListItem;
import org.broad.igv.feature.genome.GenomeManager;
import org.broad.igv.feature.genome.GenomeServerException;
import org.broad.igv.ui.IGV;
import org.broad.igv.ui.commandbar.GenomeListManager;
import org.broad.igv.ui.commandbar.GenomeSelectionDialog;
import org.broad.igv.ui.util.MessageUtils;
import org.broad.igv.ui.util.ProgressBar;
import org.broad.igv.ui.util.ProgressMonitor;
import org.broad.igv.ui.util.UIUtilities;
import org.broad.igv.util.LongRunningTask;

public class GenomeComboBox
extends JComboBox<GenomeListItem> {
    private static Logger log = Logger.getLogger(GenomeComboBox.class);

    public GenomeComboBox() {
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new GenomeBoxActionListener());
    }

    public void refreshGenomeListComboBox() {
        this.setModel(this.getModelForGenomeListComboBox());
        String curId = GenomeManager.getInstance().getGenomeId();
        GenomeListItem item = GenomeListManager.getInstance().getLoadedGenomeListItemById(curId);
        if (item != null) {
            this.setSelectedItem(item);
        }
    }

    private DefaultComboBoxModel getModelForGenomeListComboBox() {
        Collection<GenomeListItem> genomes;
        try {
            genomes = GenomeListManager.getInstance().getGenomeItemMap().values();
        }
        catch (IOException e) {
            log.error((Object)"Error reading genome list ", (Throwable)e);
            genomes = new ArrayList<GenomeListItem>();
            MessageUtils.showErrorMessage("Error reading genome list ", e);
        }
        Vector<GenomeListItem> vector = new Vector<GenomeListItem>(genomes);
        vector.sort((o1, o2) -> o1.getDisplayableName().compareTo(o2.getDisplayableName()));
        vector.add(GenomeListItem.ITEM_MORE);
        return new DefaultComboBoxModel<GenomeListItem>(vector);
    }

    public static void loadGenomeFromServer() {
        Runnable showDialog = () -> {
            List<GenomeListItem> inputListItems = GenomeListManager.getInstance().getServerGenomeList();
            if (inputListItems == null) {
                return;
            }
            GenomeSelectionDialog dialog = new GenomeSelectionDialog(IGV.getMainFrame(), inputListItems);
            UIUtilities.invokeAndWaitOnEventThread(() -> dialog.setVisible(true));
            if (dialog.isCanceled()) {
                IGVEventBus.getInstance().post(new GenomeResetEvent());
            } else {
                boolean success;
                GenomeListItem selectedValue = dialog.getSelectedValue();
                if (selectedValue != null && (success = GenomeManager.getInstance().downloadGenomes(selectedValue, dialog.downloadSequence()))) {
                    GenomeListManager.getInstance().addServerGenomeItem(selectedValue);
                    GenomeListItem firstItem = selectedValue;
                    try {
                        GenomeManager.getInstance().loadGenome(firstItem.getPath(), null);
                    }
                    catch (IOException e) {
                        GenomeListManager.getInstance().removeGenomeListItem(firstItem);
                        MessageUtils.showErrorMessage("Error loading genome " + firstItem.getDisplayableName(), e);
                        log.error((Object)("Error loading genome " + firstItem.getDisplayableName()), (Throwable)e);
                    }
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            LongRunningTask.submit(showDialog);
        } else {
            showDialog.run();
        }
    }

    static class ComboBoxRenderer
    implements ListCellRenderer {
        JSeparator separator = new JSeparator(0);

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            String text = value == null ? "" : value.toString();
            JLabel renderer = null;
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                label.setSize(label.getWidth() + 10, label.getHeight());
                renderer = label;
            }
            if (list != null) {
                if (isSelected) {
                    ((Component)renderer).setBackground(list.getSelectionBackground());
                    ((Component)renderer).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)renderer).setBackground(list.getBackground());
                    ((Component)renderer).setForeground(list.getForeground());
                }
                ((Component)renderer).setFont(list.getFont());
            }
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object selItem = GenomeComboBox.this.getSelectedItem();
            if (!(selItem instanceof GenomeListItem)) {
                return;
            }
            GenomeListItem genomeListItem = (GenomeListItem)selItem;
            this.loadGenomeListItem(genomeListItem);
        }

        private void loadGenomeListItem(final GenomeListItem genomeListItem) {
            log.info((Object)"Enter genome combo box");
            if (genomeListItem.getId().equalsIgnoreCase(GenomeManager.getInstance().getGenomeId())) {
                return;
            }
            log.info((Object)("Loading " + genomeListItem.getDisplayableName()));
            Runnable runnable = new Runnable(){
                ProgressMonitor monitor;
                ProgressBar.ProgressDialog progressDialog;

                @Override
                public void run() {
                    if (genomeListItem != null && genomeListItem.getPath() != null) {
                        log.info((Object)("Loading " + genomeListItem.getId()));
                        if (genomeListItem == GenomeListItem.ITEM_MORE) {
                            GenomeComboBox.loadGenomeFromServer();
                            return;
                        }
                        UIUtilities.invokeAndWaitOnEventThread(() -> {
                            this.monitor = new ProgressMonitor();
                            this.progressDialog = ProgressBar.showProgressDialog(IGV.getMainFrame(), "Loading Genome...", this.monitor, false);
                        });
                        try {
                            GenomeManager.getInstance().loadGenomeById(genomeListItem.getId());
                        }
                        catch (GenomeServerException e) {
                            log.error((Object)("Error loading genome: " + genomeListItem.getId() + "  " + genomeListItem.getPath()), (Throwable)e);
                            JOptionPane.showMessageDialog(IGV.getMainFrame(), "Error loading genome: " + genomeListItem.getDisplayableName());
                        }
                        catch (Exception e) {
                            log.error((Object)e);
                            int choice = JOptionPane.showConfirmDialog(IGV.getMainFrame(), "The genome [" + genomeListItem.getId() + "] could not be read. Would you like to remove the selected entry?", "", 2);
                            if (choice == 0) {
                                GenomeListManager.getInstance().removeGenomeListItem(genomeListItem);
                                GenomeComboBox.this.refreshGenomeListComboBox();
                                log.error((Object)"Error initializing genome", (Throwable)e);
                            }
                        }
                        finally {
                            if (this.progressDialog != null) {
                                UIUtilities.invokeOnEventThread(() -> this.progressDialog.setVisible(false));
                            }
                        }
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                LongRunningTask.submit(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

