/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram;

import htsjdk.samtools.CRAMBAIIndexer;
import htsjdk.samtools.CRAMCRAIIndexer;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.cram.CRAIEntry;
import htsjdk.samtools.cram.ref.ReferenceContext;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.Slice;
import htsjdk.samtools.seekablestream.SeekableMemoryStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.RuntimeIOException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class CRAIIndex {
    public static final String CRAI_INDEX_SUFFIX = ".crai";
    private final List<CRAIEntry> entries = new ArrayList<CRAIEntry>();

    public void addEntry(CRAIEntry entry) {
        this.entries.add(entry);
    }

    public void addEntries(Collection<CRAIEntry> toAdd) {
        this.entries.addAll(toAdd);
    }

    public List<CRAIEntry> getCRAIEntries() {
        return this.entries;
    }

    public void writeIndex(OutputStream os) {
        this.entries.stream().sorted().forEach(e -> e.writeToStream(os));
    }

    public void processContainer(Container container) {
        this.addEntries(container.getCRAIEntries());
    }

    public static SeekableStream openCraiFileAsBaiStream(File cramIndexFile, SAMSequenceDictionary dictionary) {
        try {
            return CRAIIndex.openCraiFileAsBaiStream(new FileInputStream(cramIndexFile), dictionary);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static SeekableStream openCraiFileAsBaiStream(InputStream indexStream, SAMSequenceDictionary dictionary) {
        List<CRAIEntry> full = CRAMCRAIIndexer.readIndex(indexStream).getCRAIEntries();
        Collections.sort(full);
        SAMFileHeader header = new SAMFileHeader();
        header.setSortOrder(SAMFileHeader.SortOrder.coordinate);
        header.setSequenceDictionary(dictionary);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRAMBAIIndexer indexer = new CRAMBAIIndexer(baos, header);
        for (CRAIEntry entry : full) {
            Slice slice = new Slice(new ReferenceContext(entry.getSequenceId()));
            slice.containerByteOffset = entry.getContainerStartByteOffset();
            slice.alignmentStart = entry.getAlignmentStart();
            slice.alignmentSpan = entry.getAlignmentSpan();
            slice.byteOffsetFromCompressionHeaderStart = entry.getSliceByteOffsetFromCompressionHeaderStart();
            slice.mappedReadsCount = 0;
            slice.unmappedReadsCount = 0;
            slice.unplacedReadsCount = 0;
            slice.index = 0;
            indexer.processAsSingleReferenceSlice(slice);
        }
        indexer.finish();
        return new SeekableMemoryStream(baos.toByteArray(), "CRAI to BAI converter");
    }

    public static List<CRAIEntry> find(List<CRAIEntry> list, int seqId, int start, int span) {
        boolean matchEntireSequence = start < 1 || span < 1;
        boolean dummyValue = true;
        CRAIEntry query = new CRAIEntry(seqId, start, span, 1L, 1, 1);
        return list.stream().filter(e -> e.getSequenceId() == seqId).filter(e -> matchEntireSequence || CRAIEntry.intersect(e, query)).sorted().collect(Collectors.toList());
    }

    public static CRAIEntry getLeftmost(List<CRAIEntry> list) {
        if (list == null || list.isEmpty()) {
            return null;
        }
        return (CRAIEntry)list.stream().sorted().findFirst().get();
    }

    public static int findLastAlignedEntry(List<CRAIEntry> list) {
        if (list.isEmpty()) {
            return -1;
        }
        int low = 0;
        int high = list.size() - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            CRAIEntry midVal = list.get(mid);
            if (midVal.getSequenceId() >= 0) {
                low = mid + 1;
                continue;
            }
            high = mid - 1;
        }
        if (low >= list.size()) {
            return list.size() - 1;
        }
        while (low >= 0 && list.get(low).getSequenceId() == -1) {
            --low;
        }
        return low;
    }

    public static class CRAIIndexException
    extends RuntimeException {
        public CRAIIndexException(String s) {
            super(s);
        }

        public CRAIIndexException(NumberFormatException e) {
            super(e);
        }
    }
}

