/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ui.legend;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.EmptyBorder;
import org.broad.igv.ui.color.ColorChooserPanel;

public class ColorMapEditor
extends JDialog {
    boolean canceled = false;
    private JPanel buttonBar;
    private JButton okButton;
    private JButton cancelButton;
    private JScrollPane scrollPane1;
    private JPanel editPanel;
    private Map<String, Color> changedColors;

    public ColorMapEditor(Frame owner, Map<String, Color> colors) {
        super(owner);
        this.setModal(true);
        this.changedColors = new HashMap<String, Color>();
        this.initComponents();
        this.initContent(colors);
        this.setSize(300, 500);
    }

    public Map<String, Color> getChangedColors() {
        if (this.canceled) {
            this.changedColors.clear();
        }
        return this.changedColors;
    }

    private void initContent(final Map<String, Color> colors) {
        for (Map.Entry<String, Color> entry : colors.entrySet()) {
            final JLabel label = new JLabel(entry.getKey());
            final ColorChooserPanel colorChooserPanel = new ColorChooserPanel(entry.getValue());
            this.editPanel.add(label);
            this.editPanel.add(colorChooserPanel);
            colorChooserPanel.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    String key = label.getText();
                    Color c = colorChooserPanel.getSelectedColor();
                    if (!((Color)colors.get(key)).equals(c)) {
                        ColorMapEditor.this.changedColors.put(key, c);
                    }
                }
            });
        }
        this.editPanel.invalidate();
    }

    public ColorMapEditor(Dialog owner) {
        super(owner);
        this.initComponents();
    }

    private void initComponents() {
        this.buttonBar = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.scrollPane1 = new JScrollPane();
        this.editPanel = new JPanel();
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapEditor.this.setVisible(false);
                ColorMapEditor.this.dispose();
            }
        });
        this.buttonBar.add((Component)this.okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ColorMapEditor.this.canceled = false;
                ColorMapEditor.this.setVisible(false);
                ColorMapEditor.this.dispose();
            }
        });
        this.buttonBar.add((Component)this.cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.buttonBar, "South");
        this.scrollPane1.setMinimumSize(new Dimension(100, 400));
        this.editPanel.setMinimumSize(new Dimension(100, 300));
        this.editPanel.setPreferredSize(new Dimension(200, 400));
        this.editPanel.setLayout(new GridLayout(0, 2));
        this.scrollPane1.setViewportView(this.editPanel);
        contentPane.add((Component)this.scrollPane1, "Center");
        this.setLocationRelativeTo(this.getOwner());
    }
}

