/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.ga4gh;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.log4j.Logger;
import org.broad.igv.prefs.PreferencesManager;
import org.broad.igv.ui.util.MessageUtils;

public class GoogleUtils {
    private static Logger log = Logger.getLogger(GoogleUtils.class);
    private static String ProjectID;
    public static String GOOGLE_API_HOST;

    public static String translateGoogleCloudURL(String gsUrl) {
        int i = gsUrl.indexOf(47, 5);
        if (i < 0) {
            log.error((Object)("Invalid gs url: " + gsUrl));
            return gsUrl;
        }
        String bucket = gsUrl.substring(5, i);
        String object = gsUrl.substring(i + 1);
        try {
            object = URLEncoder.encode(object, "UTF8");
        }
        catch (UnsupportedEncodingException e) {
            log.error((Object)e);
        }
        return "https://www.googleapis.com/storage/v1/b/" + bucket + "/o/" + object + "?alt=media";
    }

    public static void enterGoogleProjectID() {
        String projectID = MessageUtils.showInputDialog("Enter Google project ID (for \"Requestor Pays\")", GoogleUtils.getProjectID());
        if (projectID != null) {
            GoogleUtils.setProjectID(projectID);
        }
    }

    public static String getProjectID() {
        if (ProjectID == null && PreferencesManager.getPreferences().getAsBoolean("SAVE_GOOGLE_CREDENTIALS")) {
            ProjectID = PreferencesManager.getPreferences().get("GOOGLE_PROJECT");
        }
        return ProjectID;
    }

    public static void setProjectID(String projectID) {
        ProjectID = projectID;
        if (ProjectID != null && PreferencesManager.getPreferences().getAsBoolean("SAVE_GOOGLE_CREDENTIALS")) {
            PreferencesManager.getPreferences().put("GOOGLE_PROJECT", projectID);
        }
    }

    static {
        GOOGLE_API_HOST = "www.googleapis.com";
    }
}

