/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.feature.genome;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.List;
import org.broad.igv.feature.genome.Sequence;
import org.broad.igv.util.FileUtils;
import org.broad.igv.util.LittleEndianInputStream;
import org.broad.igv.util.stream.IGVSeekableStreamFactory;

public class TwoBitSequence
implements Sequence {
    static int SIGNATURE_LE = 440477507;
    static int SIGNATURE_BE = 1126646042;
    static int HEADER_BLOCK_SIZE = 12500;
    String path;

    public TwoBitSequence(String path) throws IOException {
        this.path = path;
        this.init();
    }

    private void init() throws IOException {
        SeekableStream is = null;
        is = IGVSeekableStreamFactory.getInstance().getStreamFor(this.path);
        SeekableStream bis = IGVSeekableStreamFactory.getInstance().getBufferedStream(is, 1000);
        LittleEndianInputStream lis = new LittleEndianInputStream(bis);
        int signature = lis.readInt();
        boolean littleEndian = SIGNATURE_LE == signature;
        int version = lis.readInt();
        int seqCount = lis.readInt();
        int reserved = lis.readInt();
        LinkedHashMap<String, Integer> offsets = new LinkedHashMap<String, Integer>();
        for (int i = 0; i < seqCount; ++i) {
            byte nameSize = lis.readByte();
            byte[] seqNameBytes = new byte[nameSize];
            lis.readFully(seqNameBytes);
            String seqName = new String(seqNameBytes);
            int offset = lis.readInt();
            offsets.put(seqName, offset);
        }
        for (Integer offset : offsets.values()) {
            bis.seek(offset.intValue());
            int dnaSize = lis.readInt();
            int nBlockCount = lis.readInt();
            int[] nBlockStarts = new int[nBlockCount];
            for (int i = 0; i < nBlockCount; ++i) {
                nBlockStarts[i] = lis.readInt();
            }
            int[] nBlockSizes = new int[nBlockCount];
            for (int i = 0; i < nBlockCount; ++i) {
                nBlockSizes[i] = lis.readInt();
            }
            int maskBlockCount = lis.readInt();
            int[] maskBlockStarts = new int[maskBlockCount];
            for (int i = 0; i < maskBlockCount; ++i) {
                maskBlockStarts[i] = lis.readInt();
            }
            int[] maskBlockSizes = new int[maskBlockCount];
            for (int i = 0; i < maskBlockCount; ++i) {
                maskBlockSizes[i] = lis.readInt();
            }
        }
    }

    @Override
    public byte[] getSequence(String chr, int start, int end, boolean useCache) {
        return new byte[0];
    }

    @Override
    public byte getBase(String chr, int position) {
        return 0;
    }

    @Override
    public List<String> getChromosomeNames() {
        return null;
    }

    @Override
    public int getChromosomeLength(String chrname) {
        return 0;
    }

    @Override
    public boolean isRemote() {
        return FileUtils.isRemote(this.path);
    }
}

