/*
 * Decompiled with CFR 0.152.
 */
package org.broad.igv.sam.mutreview;

import java.awt.Component;
import java.awt.Frame;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.embed.swing.JFXPanel;
import javafx.embed.swing.SwingFXUtils;
import javafx.fxml.FXML;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.RadioButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.image.WritableImage;
import javafx.scene.layout.BorderPane;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import org.apache.log4j.Logger;
import org.broad.igv.sam.mutreview.GoogleCloudStorageHelper;
import org.broad.igv.sam.mutreview.VariantReviewMetadata;
import org.broad.igv.ui.util.MessageUtils;

public class VariantReviewFX {
    private static Logger log = Logger.getLogger(VariantReviewFX.class);
    private JDialog dialog;
    private BufferedImage image;
    private VariantReviewMetadata metadata;
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ToggleGroup artifactGroup;
    @FXML
    private ImageView imageView;

    @FXML
    void initialize() {
        assert (this.artifactGroup != null) : "fx:id=\"artifactGroup\" was not injected: check your FXML file 'VariantReview.fxml'.";
    }

    @FXML
    void submit() {
        RadioButton selectedButton = (RadioButton)this.artifactGroup.getSelectedToggle();
        if (selectedButton == null) {
            MessageUtils.showMessage("No call selected");
        } else {
            String selectedButtonText = selectedButton.getText().toLowerCase();
            int score = -1;
            if ("yes".equals(selectedButtonText)) {
                score = 0;
            } else if ("no".equals(selectedButtonText)) {
                score = 1;
            } else if ("unknown".equals(selectedButtonText)) {
                score = 2;
            }
            this.metadata.score = score;
            try {
                GoogleCloudStorageHelper.upload(this.image, this.metadata);
            }
            catch (IOException e) {
                MessageUtils.showErrorMessage("Error uploading data", e);
                log.error(e);
            }
            SwingUtilities.invokeLater(() -> this.dialog.setVisible(false));
        }
    }

    @FXML
    void cancel() {
        SwingUtilities.invokeLater(() -> this.dialog.setVisible(false));
    }

    public static void open(Frame parent, BufferedImage bufferedImage, VariantReviewMetadata metadata) throws IOException {
        SwingUtilities.invokeLater(() -> {
            try {
                JDialog frame = new JDialog(parent, "Preferences", true);
                JFXPanel fxPanel = new JFXPanel();
                FXMLLoader loader = new FXMLLoader(VariantReviewFX.class.getResource("VariantReview.fxml"));
                BorderPane pane = (BorderPane)loader.load();
                VariantReviewFX controller = (VariantReviewFX)loader.getController();
                controller.dialog = frame;
                controller.image = bufferedImage;
                controller.metadata = metadata;
                WritableImage image = SwingFXUtils.toFXImage((BufferedImage)bufferedImage, null);
                controller.imageView.setImage((Image)image);
                fxPanel.setScene(new Scene((Parent)pane));
                frame.add((Component)fxPanel);
                frame.pack();
                frame.setSize(950, 800);
                frame.setLocationRelativeTo(parent);
                frame.setVisible(true);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }
}

